<?php
$this->load->view('includes/top');
?>
<div class="main-container" id="container">
  <?php $this->load->view('includes/left'); ?>
  <div id="content" class="main-content">
    <div class="layout-px-spacing">
      <div class="row layout-top-spacing layout-spacing">
        <div class="col-lg-12">
          <div class="statbox widget box box-shadow">
            <div class="widget-header">
              <div class="row">
                <div class="col-xl-8 col-md-8 col-sm-8 col-8">
                  <h4>Manage Content Sets for <?php echo $subcontentTitle; ?></h4>
                </div>
                <div class="col-xl-4 col-md-4 col-sm-4 col-4 text-right">
                <h4><a href="<?php echo base_url('wps-admin/subcontent/add_set/' . $pageVal['subcontentId']); ?>" ><i class="fa fa-plus"></i> Add/Edit</a></h4>
                </div>
        
              </div>
            </div>
            <div class="widget-content widget-content-area">
              <div class="table-responsive mb-4">
                <table class="table table-hover">
                  <thead>
                    <tr>
                      <th>Set Name</th>
                      <th>Locations</th>
                      <!-- <th>Meta Title</th> -->
                      <th>Status</th>
                      <th>Action</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php if(!empty($sets)) {
                      foreach($sets as $set) { ?>
                        <tr>
                          <td><?php echo $set->set_name; ?></td>
                          <!-- <td><?php echo $set->location_id; ?></td> -->
                           <td>
  <?php
  $locationNames = [];
  if (!empty($set->location_id)) {
      $ids = explode(',', $set->location_id);
      foreach ($ids as $lid) {
          // Fetch name from location array if you already have $locations list
          foreach ($locations as $loc) {
              if ($loc['meta_id'] == $lid) {
                  $locationNames[] = ucwords($loc['page_url']);
                  break;
              }
          }
      }
  }
  echo !empty($locationNames) ? implode(', ', $locationNames) : '-';
  ?>
</td>
                          <!-- <td><?php echo $set->meta_title; ?></td> -->
                          <td><?php echo ($set->status=='1'?'Active':'Inactive'); ?></td>
                         <td>
<a href="<?php echo base_url('wps-admin/subcontent/add_set/'.$set->subcontent_id.'/'.$set->set_id); ?>" class="btn btn-success btn-sm">
  Edit
</a>

<a href="<?php echo base_url('wps-admin/subcontent/delete_set/'.$set->subcontent_id.'/'.$set->set_id); ?>" 
   class="btn btn-danger btn-sm" 
   onclick="return confirm('Delete this set?');">
   Delete
</a>
</td>
                        </tr>
                      <?php } } else { ?>
                        <tr><td colspan="5">No sets found.</td></tr>
                    <?php } ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php die(); ?>