<?php $this->load->view('includes/top'); ?>
<div class="main-container" id="container">
  <div class="overlay"></div>
  <div class="search-overlay"></div>
  <?php $this->load->view('includes/left'); ?>

  <div id="content" class="main-content">
    <div class="layout-px-spacing">
      <div class="row layout-top-spacing layout-spacing">
        <div class="col-lg-12">
          <div class="statbox widget box box-shadow">
            <?php
            echo form_open_multipart("", ['id' => 'data_form']);
            echo success_message();
            ?>
            
            <div class="widget-header">
              <div class="row">
                <div class="col-xl-6 col-md-6 col-sm-6 col-6">
                  <h4><?php echo $headingTitle; ?></h4>
                </div>
                <div class="col-xl-6 col-md-6 col-sm-6 col-6 text-right">
                  <a href="<?php echo base_url("wps-admin/subcontent/sets/$subcontent_id"); ?>" class="btn btn-danger btn-sm mb-2">
                    <i class="fa fa-exclamation-circle"></i> Cancel
                  </a>
                  <button type="submit" class="btn btn-primary btn-sm mb-2">
                    <i class="fa fa-plus"></i> Save
                  </button>
                </div>
              </div>
            </div>

            <div class="widget-content widget-content-area">
              <div class="table-responsive mb-4">

                <!-- Category -->
                <div class="form-group row mb-4">
                  <label class="col-sm-3 col-form-label col-form-label-sm"><span class="red">*</span>Category</label>
                  <div class="col-sm-6">
                    <input type="text" class="form-control" value="<?php echo htmlspecialchars($category_name); ?>" readonly>
                  </div>
                </div>

                <!-- Location -->
<div class="form-group row mb-4">
  <label class="col-sm-3 col-form-label col-form-label-sm">
    <span class="red">*</span>Location
  </label>
  <div class="col-sm-6">
    <div style="max-height: 220px; overflow-y: auto; border: 1px solid #ddd; padding: 10px; border-radius: 6px;">
      <div style="display: grid; grid-template-columns: repeat(5, 1fr); gap: 6px;">
        <?php
        $selArray = [];
        if (!empty($res['location_id'])) {
            $selArray = explode(',', $res['location_id']);
        } elseif ($this->input->post('location_id')) {
            $selArray = $this->input->post('location_id');
        }

        if (!empty($locations)) {
            foreach ($locations as $lval) {
                $checked = in_array($lval['meta_id'], $selArray) ? 'checked' : '';
                echo '
                <label style="font-weight: normal; white-space: nowrap;">
                  <input type="checkbox" name="location_id[]" value="' . $lval['meta_id'] . '" ' . $checked . '> 
                  ' . ucwords($lval['page_url']) . '
                </label>';
            }
        } else {
            echo '<p>No locations found.</p>';
        }
        ?>
      </div>
    </div>
    <?php echo form_error('location_id'); ?>
  </div>
</div>




                <!-- Page Heading -->
                <div class="form-group row mb-4">
                  <label class="col-sm-3 col-form-label col-form-label-sm"><span class="red">*</span>Heading</label>
                  <div class="col-sm-6">
                     <input type="text" class="form-control" name="page_heading" id="page_heading"
           value="<?php echo set_value('page_heading', @$res['page_heading']); ?>" />
    <?php echo form_error('page_heading'); ?>
                    <small class="text-muted"><b style="color:#660000;">Example:</b> Buy {catname} online in {location}</small>
                  </div>
                </div>

                <!-- Description -->
                <div class="form-group row mb-4">
                  <label class="col-sm-3 col-form-label col-form-label-sm"><span class="red">*</span>Description</label>
                  <div class="col-sm-6">
                    <textarea class="form-control" name="description" id="description"><?php echo set_value('description', @$res['description']); ?></textarea>
    <?php echo form_error('description'); ?>
    <?php echo display_ckeditor($ckeditor); ?>
                    <small class="text-muted"><b style="color:#660000;">Example:</b> Contrary to {location} belief, Lorem {catname} is not simply random text.</small>
                  </div>
                </div>

                <!-- Short Description -->
                <div class="form-group row mb-4">
                  <label class="col-sm-3 col-form-label col-form-label-sm"><span class="red">*</span>Short Description</label>
                  <div class="col-sm-6">
                   <textarea class="form-control" name="short_description" id="short_description"><?php echo set_value('short_description', @$res['short_description']); ?></textarea>
    <?php echo form_error('short_description'); ?>
                    <small class="text-muted"><b style="color:#660000;">Example:</b> Contrary to {location} belief, Lorem {catname} is not simply random text.</small>
                  </div>
                </div>

                <!-- Meta Title -->
                <div class="form-group row mb-4">
                  <label class="col-sm-3 col-form-label col-form-label-sm"><span class="red">*</span>Title</label>
                  <div class="col-sm-6">
                    <input type="text" class="form-control" name="meta_title" id="meta_title"
           value="<?php echo set_value('meta_title', @$res['meta_title']); ?>" />
    <?php echo form_error('meta_title'); ?>
                    <small class="text-muted"><b style="color:#660000;">Example:</b> {catname} manufacturer in {location}</small>
                  </div>
                </div>

                <!-- Meta Keywords -->
                <div class="form-group row mb-4">
                  <label class="col-sm-3 col-form-label col-form-label-sm"><span class="red">*</span>Keywords</label>
                  <div class="col-sm-6">
                     <textarea class="form-control" name="meta_keyword" rows="5" id="meta_keyword"><?php echo set_value('meta_keyword', @$res['meta_keyword']); ?></textarea>
    <?php echo form_error('meta_keyword'); ?>
                    <small class="text-muted"><b style="color:#660000;">Example:</b> {catname} manufacturer in {location}</small>
                  </div>
                </div>

                <!-- Meta Description -->
                <div class="form-group row mb-4">
                  <label class="col-sm-3 col-form-label col-form-label-sm"><span class="red">*</span>Description</label>
                  <div class="col-sm-6">
                      <textarea class="form-control" name="meta_description" rows="5" id="meta_description"><?php echo set_value('meta_description', @$res['meta_description']); ?></textarea>
    <?php echo form_error('meta_description'); ?>
                    <small class="text-muted"><b style="color:#660000;">Example:</b> {catname} manufacturer in {location}</small>
                  </div>
                </div>
              </div>

               <div class="form-group">
                <label>Status</label><br>
                <label><input type="checkbox" name="status" value="1" <?php echo (@$res['status'] == 1) ? 'checked' : ''; ?>> Active</label>
              </div>


              <div class="widget-header">
                <div class="row">
                  <div class="col-xl-6 col-md-6 col-sm-6 col-6">&nbsp;</div>
                  <div class="col-xl-6 col-md-6 col-sm-6 col-6 text-right">
                    <a href="<?php echo base_url("wps-admin/subcontent/sets/$subcontent_id"); ?>" class="btn btn-danger btn-sm mb-2">
                      <i class="fa fa-exclamation-circle"></i> Cancel
                    </a>
                    <input type="hidden" name="submit" value="submit">
                    <button type="submit" class="btn btn-primary btn-sm mb-2">
                      <i class="fa fa-plus"></i> Save
                    </button>
                  </div>
                </div>
              </div>

              <?php echo form_close(); ?>
            </div>
          </div>
        </div>
      </div>

      <div class="footer-wrapper">
        <div class="footer-section f-section-1">
          <p class="terms-conditions">All Rights Reserved. Powered By <a href="https://www.webpulseindia.com/" target="_blank">Webpulse</a></p>
        </div>
        <div class="footer-section f-section-2">
          <p>Coded with ❤️</p>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $this->load->view('includes/bottom'); ?>
