<?php

class Subcontent extends Admin_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('subcontent_model'));
    $this->load->helper('category/category');
  }

  //Country
  public function index() {
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));

    $keyword = trim($this->input->get_post('keyword', TRUE));
    $keyword = $this->db->escape_str($keyword);
    $condtion = " ";
    if ($keyword != '') {
      $condtion = "AND (description like '%" . $keyword . "%' OR shortdescription like '%" . $keyword . "%')";
    }

    $condtion_array = array();
    $res_array = $this->subcontent_model->get_record();
    $config['total_rows'] = $this->subcontent_model->total_rec_found;

    $data['headingTitle'] = "Manage Sub Domain Content";
    $data['res'] = $res_array;

    if ($this->input->post('status_action') != '') {
      $this->update_status('wps_subcontent', 'subcontentId');
    }

    $this->load->view('subcontent/subcontent_list_view', $data);
    
  }

  public function add() {

    $data['headingTitle'] = "Add Sub Domain Content";
    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'description'));
    if ($this->input->post('submit')) {

      $this->form_validation->set_rules('category_id[]', "Categories", "required");
      $this->form_validation->set_rules('page_heading', "Page Heading", "trim|max_length[220]");
      $this->form_validation->set_rules('description', "Description", "trim|required");
      $this->form_validation->set_rules('short_description', "Short Description", "trim|required");
      $this->form_validation->set_rules('meta_title', "Meta Title", "trim|required|max_length[220]");
      $this->form_validation->set_rules('meta_keyword', "Meta Keyword", "trim|required|max_length[460]");
      $this->form_validation->set_rules('meta_description', "Meta Description", "trim|required|max_length[350]");

      if ($this->form_validation->run() == TRUE) {

        //Category Links
        $postCategory = array();
        if ($this->input->post('category_id')) {
          $postCategory = $this->input->post('category_id');
        }

        //Location
        $postLocation = array();
        if ($this->input->post('location_id')) {
          $postLocation = $this->input->post('location_id');
        }

        //Insert in meta table
        $posted_data = array(
            'description' => $this->input->post('description'),
            'short_description' => $this->input->post('short_description'),
            'page_heading' => $this->input->post('page_heading'),
            'meta_keyword' => $this->input->post('meta_keyword'),
            'meta_description' => $this->input->post('meta_description'),
            'meta_title' => $this->input->post('meta_title'),
            'category_id' => implode(",", $postCategory),
            'location_id' => implode(",", $postLocation),
        );
        //trace($posted_data);
        //die;
        $this->subcontent_model->safe_insert('wps_subcontent', $posted_data, FALSE);

        $this->session->set_flashdata('success', lang('success'));
        redirect("wps-admin/subcontent/");
      }
    }
    $data['locations'] = $this->db->query("SELECT meta_id,page_url FROM wps_meta_tags WHERE is_fixed='L' ORDER BY page_url")->result_array();
    $this->load->view("subcontent/add_subcontent", $data);
  }

  public function edit() {
    $id = $this->uri->segment(4, 0);

    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'description'));
    $data['headingTitle'] = "Edit Subdomain Meta & Content";
    $res = $this->db->query("SELECT * FROM wps_subcontent WHERE subcontentId='".$id."'")->row_array();
    $data['res'] = $res;

    if ($this->input->post('update')) {

      $this->form_validation->set_rules('category_id[]', "Categories", "required");

      $this->form_validation->set_rules('page_heading', "Page Heading", "trim|max_length[220]");
      $this->form_validation->set_rules('description', "Description", "trim|required");
      $this->form_validation->set_rules('short_description', "Short Description", "trim|required");
      $this->form_validation->set_rules('meta_title', "Meta Title", "trim|required|max_length[220]");
      $this->form_validation->set_rules('meta_keyword', "Meta Keyword", "trim|required|max_length[460]");
      $this->form_validation->set_rules('meta_description', "Meta Description", "trim|required|max_length[350]");

      if ($this->form_validation->run() == TRUE) {
        //Category
        $postCategory = array();
        if ($this->input->post('category_id')) {
          $postCategory = $this->input->post('category_id');
        }

        //Location
        $postLocation = array();
        if ($this->input->post('location_id')) {
          $postLocation = $this->input->post('location_id');
        }

        //Insert in meta table
        $posted_data = array(
            'description' => $this->input->post('description'),
            'short_description' => $this->input->post('short_description'),
            'page_heading' => $this->input->post('page_heading'),
            'meta_keyword' => $this->input->post('meta_keyword'),
            'meta_description' => $this->input->post('meta_description'),
            'meta_title' => $this->input->post('meta_title'),
            'category_id' => implode(",", $postCategory),
            'location_id' => implode(",", $postLocation),
        );
        //trace($posted_data);
        //die;
        $where_meta = "subcontentId=" . $id . " ";
        $this->subcontent_model->safe_update('wps_subcontent', $posted_data, $where_meta, FALSE);
        $this->session->set_flashdata('success', lang('successupdate'));
        redirect("wps-admin/subcontent/");
      }
    }
    $data['locations'] = $this->db->query("SELECT meta_id,page_url FROM wps_meta_tags WHERE is_fixed='L' ORDER BY page_url")->result_array();
    $this->load->view("subcontent/edit_subcontent", $data);
  }
//   public function sets() {
//   $data['headingTitle'] = "Manage Subcontent Sets";

//   // Fetch all meta sets (from wps_meta_sets table)
//   // $data['sets'] = $this->subcontent_model->get_meta_sets();

//   // Load the view for sets
//   $this->load->view("subcontent/subcontent_sets", $data);
// }
public function sets($subcontentId = 0)
{
    // Get subcontent title
    $subcontent = $this->db->query("SELECT page_heading FROM wps_subcontent WHERE subcontentId='$subcontentId'")->row_array();

    // Define view data
    $data['subcontentTitle'] = !empty($subcontent['page_heading']) ? $subcontent['page_heading'] : 'Unknown Subcontent';
    $data['pageVal'] = ['subcontentId' => $subcontentId]; // ✅ fixes "undefined $pageVal"
    $data['headingTitle'] = "Manage Sub Domain Content Sets";
     $data['locations'] = $this->db
        ->query("SELECT meta_id, page_url FROM wps_meta_tags WHERE is_fixed='L' ORDER BY page_url")
        ->result_array();

    // Fetch all sets belonging to this subcontentId
    $data['sets'] = $this->db->query("SELECT * FROM wps_subcontent_sets WHERE subcontent_id='$subcontentId' ORDER BY set_id DESC")->result();

    $this->load->view('subcontent/subcontent_sets', $data);
}


public function add_set($subcontentId = 0, $setId = 0)
{
    $data['ckeditor'] = set_ck_config(['textarea_id' => 'description']);
    $data['headingTitle'] = !empty($setId) ? "Edit Sub Domain Content Set" : "Add Sub Domain Content Set";
    $data['subcontent_id'] = $subcontentId;

    // Fetch category info
    $subcontent = $this->db->get_where('wps_subcontent', ['category_id' => $subcontentId])->row_array();
    if ($subcontent) {
        $catID = $subcontent['category_id'] ?? 0;
        $catRow = $this->db->get_where('wps_categories', ['category_id' => $catID])->row_array();
        $data['category_name'] = $catRow['category_name'] ?? 'N/A';
        $data['category_id'] = $catID;
    } else {
        $data['category_name'] = 'N/A';
        $data['category_id'] = 0;
    }

    // Load locations
    $data['locations'] = $this->db->query("SELECT meta_id, page_url FROM wps_meta_tags WHERE is_fixed='L' ORDER BY page_url")->result_array();

    // Load record if editing
    $data['res'] = !empty($setId)
        ? $this->db->get_where('wps_subcontent_sets', ['set_id' => $setId])->row_array()
        : [];

    // Handle form submit
    if ($this->input->post('submit')) {

        // $this->form_validation->set_rules('meta_title', "Meta Title", "trim|required|max_length[500]");
        // $this->form_validation->set_rules('meta_description', "Meta Description", "trim|required|max_length[350]");
        // $this->form_validation->set_rules('page_heading', "Page Heading", "trim|required|max_length[220]");
        $this->form_validation->set_rules('short_description', "Short Description", "trim|required");
        $this->form_validation->set_rules('description', "Description", "trim|required");

        if ($this->form_validation->run() === TRUE) {

            // ✅ Get selected locations safely
            $postLocation = $this->input->post('location_id') ?? [];
            $locationString = !empty($postLocation) ? implode(",", $postLocation) : '';

            // ✅ Auto increment set_name (Set 1, Set 2...) only for ADD
            if (empty($setId)) {
                $this->db->where('subcontent_id', $subcontentId);
                $countSets = $this->db->count_all_results('wps_subcontent_sets');
                $nextSetNumber = $countSets + 1;
                $setName = 'Set ' . $nextSetNumber;
            } else {
                $setName = $data['res']['set_name'] ?? 'Set 1';
            }

            $status = $this->input->post('status') ? 1 : 0;

            $posted_data = [
                'subcontent_id'     => $subcontentId,
                'location_id'       => $locationString,
                'page_heading'      => $this->input->post('page_heading'),
                'description'       => $this->input->post('description'),
                'short_description' => $this->input->post('short_description'),
                'meta_title'        => $this->input->post('meta_title'),
                'meta_keyword'      => $this->input->post('meta_keyword'),
                'meta_description'  => $this->input->post('meta_description'),
                'set_name'          => $setName,
                
            ];

            if (!empty($setId)) {
                $this->db->where('set_id', $setId);
                $this->db->update('wps_subcontent_sets', $posted_data);
                $this->session->set_flashdata('success', 'Content Set Updated Successfully.');
            } else {
                $this->db->insert('wps_subcontent_sets', $posted_data);
                $this->session->set_flashdata('success', 'Content Set Added Successfully.');
            }

            redirect("wps-admin/subcontent/sets/$subcontentId");
        }
    }

    $this->load->view("subcontent/add_edit_set", $data);
}


// ==================== DELETE SET ====================
public function delete_set($subcontentId = 0, $setId = 0)
{
    if (!empty($setId)) {
        $this->db->where('set_id', $setId);
        $this->db->delete('wps_subcontent_sets');
        $this->session->set_flashdata('success', 'Set deleted successfully.');
    } else {
        $this->session->set_flashdata('error', 'Invalid Set ID.');
    }

    // Redirect back to correct listing page
    redirect("wps-admin/subcontent/sets/$subcontentId");
}




}
// End of controller
