<?php $this->load->view('footer'); ?>
<!-- Product Popup -->
<div class="modal fade" id="productID" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <div class="modal-title">Send Enquiry</div>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-lg-6 col-md-6">
                        <div class="product_popup">
                            <div class="product_popup_image">
                                <img src="<?php echo get_image('', '', '500', '500', 'R'); ?>" id="productQuoteImage" alt="Ederra Home Studio" title="Ederra Home Studio">
                            </div>
                            <div id="companyProDetails">Ederra Home Studio</div>
                            <div id="proDescription"></div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6">
                        <div class="alert alert-warning EmessageBox" style="display: none;">
                            <span class="Emessage"></span>
                        </div>
                        <div class="alert alert-success SmessageBox" style="display: none;">
                            <span class="Smessage"></span>
                        </div>
                        <form name="contact-form" method="post" id="getQuoteForm">
                            
                            <input type="hidden" name="productQuoteID" id="productQuoteID">
                            <input type="hidden" name="proType" id="proType">
                            <input type="hidden" name="proName" id="proName">
                            <input type="hidden" name="post_url" id="post_url">
                            <div class="form-group">
                                <input tabindex="001" class="form-control" type="text" id="fullName" name="fullName"
                                    placeholder="Your Name*" value="" pattern="[a-z A-Z]+" required>
                            </div>
                            <div class="form-group">
                                <input tabindex="002" class="form-control" type="email" id="emailAddress" name="emailAddress"
                                    placeholder="Your Email ID*" value="" required>
                            </div>
                            <div class="form-group">
                                <input tabindex="003" class="form-control" type="tel" id="mobileNumber" name="mobileNumber"
                                    placeholder="Your Mobile No*" minlength="6" maxlength="15" value="" required>
                            </div>
                            <div class="form-group">
                                <input tabindex="004" class="form-control" type="text" id="location" name="location"
                                    placeholder="Your Location*" value=""
                                    pattern="[a-z A-Z]+" autocomplete="off" required>
                            </div>
                            <div class="form-group">
                                <textarea tabindex="005" class="form-control" name="enquiryMessage" id="enquiryMessage" placeholder="Your Message*"
                                    required></textarea>
                            </div>
                            <div class="form-group" style="margin-bottom: 0;">
                                <div tabindex="6" class="g-recaptcha" data-sitekey="<?php echo CAPTCHA_SITEKEY; ?>"></div>
                                <?php echo form_error('g-recaptcha-response'); ?>
                            </div>
                            <div class="form-group">
                                <button tabindex="007" class="modal_btn" type="submit" name="submit" value="Submit"
                                    data-submit="...Sending">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        //get quote
        $('.getQuotes').click(function() {
            var productType = $(this).attr('data-productType');
            var productID = $(this).attr('data-ProductID');
            var productName = $(this).attr('data-ProductName');
            var proDescription = $(this).attr('data-proDescription');
            var productImage = $(this).attr('data-ProductImage');
            var friendly_url = $(this).attr('data-friendly_url');
            $('#productQuoteImage').attr('src', productImage);
            //$('#productQuoteImage').css({"border": "3px solid #CCC"});
            $('#companyProDetails').html('');
            $('#companyProDetails').html(productName);
            $('#proDescription').html('');
            $('#proDescription').html(proDescription);
            $('#proName').val(productName);
            $('#productQuoteID').val(productID);
            $('#proType').val(productType);
            $('#post_url').val(friendly_url);
        });
        //post enquiry
        $('#getQuoteForm').submit(function(e) {
            e.preventDefault();
            var fullName = $('#fullName').val();
            var mobileNumber = $('#mobileNumber').val();
            var emailAddress = $('#emailAddress').val();
            var enquiryMessage = $('#enquiryMessage').val();
            var productID = $('#productQuoteID').val();
            var proName = $('#proName').val();
            //var country = $('#country').val();
            var location = $('#location').val();
            var post_url = $('#post_url').val();
            var proType = $('#proType').val();
            var type = '4';
            $.post('<?php echo site_url(); ?>products/postEnquiry', {
                fullName: fullName,
                mobileNumber: mobileNumber,
                emailAddress: emailAddress,
                enquiryMessage: enquiryMessage,
                productID: productID,
                proName: proName,
                post_url: post_url,
                location: location,
                type: type,
                proType: proType
            }, function(response) {
                //alert(response);
                obj = JSON.parse(response);
                if (obj.success == 'true') {
                    $('.SmessageBox').show(0);
                    $('.EmessageBox').hide(0);
                    $('.Emessage').html('');
                    $('.Smessage').html('');
                    $('.Smessage').html(obj.message);
                    $('#getQuoteForm')[0].reset();
                } else {
                    $('.EmessageBox').show();
                    $('.SmessageBox').hide();
                    $('.Smessage').html('');
                    $('.Emessage').html('');
                    $('.Emessage').html(obj.error);
                }
            });
        });
    });
</script>


<?php
$country = $this->db->query("SELECT id, name from wps_countries_list WHERE 1")->result_array();
$adminRes = get_site_email();
$WhatsApp = $adminRes->whatsapp_no;
?>
<?php if ($WhatsApp != "") { ?>
    <button class="whatapp_btn border-none border-0" data-toggle="modal" data-target="#whatsapp" title="Whatsapp Now"><i
            class="fa fa-whatsapp"></i></button>
    <div class="modal fade" id="whatsapp" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;
                    </button>
                    <div class="modal-title">Message on WhatsApp</div>
                </div>
                <div class="modal-body">
                    <div id="status_response"></div>
                    <form id="whatsappEnq" method="post">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <input tabindex="1" class="form-control" type="text" placeholder="Your Name*" id="wname"
                                        name="wname" required>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <input tabindex="3" class="form-control" type="text" id="wmobile"
                                        placeholder="Your Mobile Number*" maxlength="15" minlength="6" name="wmobile"
                                        onkeyup="if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,'')"
                                        onkeypress="return isNumberKey(event)" required>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <button tabindex="7" class="modal_btn whatsEnq" type="submit" name="submit" value="Submit"
                                    data-submit="...Sending">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            $('.whatsEnq').click(function(e) {
                e.preventDefault();
                var wname = $('#wname').val();
                var wmobile = $('#wmobile').val();
                $.ajax({
                    url: "<?php echo site_url(); ?>pages/whatsappenq",
                    data: $('#whatsappEnq').serialize(),
                    type: "POST",
                    success: function(data) {
                        if (data == 'success') {
                            $('#status_response').html(
                                '<div class="alert alert-success">Whatsapp Enquiry Submitted successfully</div>'
                            );
                            $('#whatsappEnq').trigger('reset');
                            window.open(
                                "https://api.whatsapp.com/send?phone=<?php echo $WhatsApp; ?>&text=Hii,I Contacted you through your Website (<?php echo $this->config->item('site_name_www'); ?>).Kindly Call me Thank you!&source=&data=&app_absent="
                            );
                        } else {
                            $('#status_response').html(data);
                        }
                    }
                });
            });
        });
    </script>
<?php } ?>
<button class="enquiry border-0 border-none w-auto" data-toggle="modal" data-target="#myModal" title="Send Enquiry">
    <i class="fa fa-envelope"></i>
    <strong>Send Enquiry</strong></button>
 
<!-- QUICK ENQUIRY BUTTON -->
<button class="enquiry border-0 border-none w-auto" data-toggle="modal" data-target="#myModal" title="Send Enquiry">
    <i class="fa fa-envelope"></i>
    <strong>Send Enquiry</strong>
</button>

<!-- QUICK ENQUIRY MODAL -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <div class="modal-title">Quick Enquiry</div>
            </div>
            <div class="modal-body">
                <p class="send_p">If you have an urgent requirement, please fill the form or dial contact number:
                    <?php echo $adminRes->phone; ?></p>
                <div id="form-status1"></div>
                <form name="contact-form" method="post" id="getQuoteForm2">
                  

                    <!-- Hidden fields -->
                    <input type="hidden" name="productQuoteID" id="productQuoteID2">
                    <input type="hidden" name="proType" id="proType2">
                    <input type="hidden" name="proName" id="proName2">
                    <input type="hidden" name="post_url" id="post_url2">

                    <!-- User input fields -->
                    <div class="form-group">
                        <input class="form-control" type="text" id="fullName2" name="fullName" placeholder="Your Name*" value=""
                            pattern="[a-zA-Z ]+" required>
                    </div>
                    <div class="form-group">
                        <input class="form-control" type="email" id="emailAddress2" name="emailAddress"
                            placeholder="Your Email ID*" value="" required>
                    </div>
                    <div class="form-group">
                        <input class="form-control" type="tel" id="mobileNumber2" name="mobileNumber"
                            placeholder="Your Mobile No*" minlength="6" maxlength="15" value="" required>
                    </div>
                    <div class="form-group">
                        <input class="form-control" type="text" id="location2" name="location" placeholder="Your Location*" value=""
                            pattern="[a-zA-Z ]+" autocomplete="off" required>
                    </div>
                    <div class="form-group">
                        <textarea class="form-control" name="enquiryMessage" id="enquiryMessage2" placeholder="Your Message*"
                            required></textarea>
                    </div>

                    <!-- reCAPTCHA with hidden response -->
                    <div class="form-group" style="margin-bottom: 0;">
                        <div class="g-recaptcha" data-sitekey="<?php echo CAPTCHA_SITEKEY; ?>" data-callback="verifyCaptcha2"
                            data-expired-callback="expireCaptcha2" id="recaptcha2"></div>
                        <input type="hidden" name="g-recaptcha-response" id="g-recaptcha-response2">
                        <?php echo form_error('g-recaptcha-response'); ?>
                    </div>

                    <div class="form-group">
                        <button class="modal_btn" type="submit" name="submit" value="Submit"
                            data-submit="...Sending">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    // reCAPTCHA token handlers
    function verifyCaptcha2(token) {
        document.getElementById('g-recaptcha-response2').value = token;
    }

    function expireCaptcha2() {
        document.getElementById('g-recaptcha-response2').value = '';
    }

    $(document).ready(function() {
        $('#getQuoteForm2').submit(function(e) {
            e.preventDefault();

            var fullName = $('#fullName2').val();
            var mobileNumber = $('#mobileNumber2').val();
            var emailAddress = $('#emailAddress2').val();
            var enquiryMessage = $('#enquiryMessage2').val();
            var productID = $('#productQuoteID2').val();
            var proName = $('#proName2').val();
            var location = $('#location2').val();
            var post_url = $('#post_url2').val();
            var proType = $('#proType2').val();
            var type = '4';

            var recaptchaResponse = $('#g-recaptcha-response2').val();
            if (recaptchaResponse === "") {
                alert("Please verify captcha.");
                return false;
            }

            $.post('<?php echo site_url(); ?>products/postEnquiry', {
                fullName: fullName,
                mobileNumber: mobileNumber,
                emailAddress: emailAddress,
                enquiryMessage: enquiryMessage,
                productID: productID,
                proName: proName,
                post_url: post_url,
                location: location,
                type: type,
                proType: proType,
                'g-recaptcha-response': recaptchaResponse
            }, function(response) {
                var obj = JSON.parse(response);
                if (obj.success === 'true') {
                    $('#form-status1').html('<div class="alert alert-success">' + obj.message + '</div>');
                    $('#getQuoteForm2')[0].reset();
                    grecaptcha.reset(); // reset captcha
                    $('#g-recaptcha-response2').val('');
                } else {
                    $('#form-status1').html('<div class="alert alert-danger">' + obj.error + '</div>');
                    grecaptcha.reset();
                    $('#g-recaptcha-response2').val('');
                }
            });
        });
    });
</script>


<script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/js/bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/wow/1.0.2/wow.min.js"></script>
<script src="<?php echo theme_url(); ?>js/slick.min.js"></script>
<script src="<?php echo theme_url(); ?>js/slick-animation.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.9.0/jquery.validate.min.js"></script>
<script src="<?php echo theme_url(); ?>js/themes.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.2.0/jquery.fancybox.min.js"></script>
<script>
    function isAlphaNumeric(key) {
        var regex = new RegExp("^[A-Za-z0-9? ,_-]+$");
        var key = String.fromCharCode(event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
    }

    function isAlpha(key) {
        var regex = new RegExp("^[a-zA-Z]+$");
        var key = String.fromCharCode(event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
    }

    function isNumberKey(evt) {
        var charCode = (evt.which) ? evt.which : event.keyCode;
        if ((charCode < 48 || charCode > 57))
            return false;
        return true;
    }
</script>
<?php if ($this->router->fetch_class() == 'pages' && $this->router->fetch_method() == 'contactus') { ?>
<?php } ?>
</body>

</html>