<?php

class Redirection extends Admin_Controller

{

	public function __construct()

	{		

		parent::__construct(); 				

		$this->load->model(array('redirection_model'));			

	}

	 

	public  function index()

	{

		

		

		 $pagesize               =  (int) $this->input->get_post('pagesize');

	     $config['limit']		 =  ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');		 		 				

		 $offset                 =  ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;		

		 $base_url               =  current_url_query_string(array('filter'=>'result'),array('per_page'));				 

		 $parent_id              =   (int) $this->uri->segment(4,0);			

	     

		 $keyword = trim($this->input->get_post('keyword',TRUE));		

		 $keyword = $this->db->escape_str($keyword);

	     $condtion = " ";

		 

		

									

		$condtion_array = array(

		                'field' =>"*",

						 'index'=>'id',

						 'condition'=>$condtion,

						 'limit'=>$config['limit'],

						  'offset'=>$offset	,

						  'debug'=>FALSE

						 );							 						 	

		$res_array              =  $this->redirection_model->get_redirection($condtion_array);



		$config['total_rows']	=  $this->redirection_model->total_rec_found;	

		

		$data['page_links']     =  dashboard_pagination($base_url,$config['total_rows'],$config['limit'],$offset);

				

		$data['headingTitle']  =  '301 Redirection';

						

		$data['res']            =  $res_array; 	

		

		
		

		if( $this->input->post('action')!='')

		{			

			$this->update_status('wps_redirection_tbl','id');			

		}

		
						

		$this->load->view('redirection/view_redirection_list',$data);		

		

		

	}	

	

	public function add()

	{

		 $data['headingTitle'] = 'Add New Redirection URL';

		

		 $this->form_validation->set_rules('old_url','Old URL',"trim|required");

		$this->form_validation->set_rules('new_url','New URL',"trim|required");

		

		 

		if($this->form_validation->run()===TRUE)

		{

			    $posted_data = array(

					'old_url'=>$this->input->post('old_url'),

					'new_url'=>$this->input->post('new_url'),

					'Added_on'=>$this->config->item('config.date.time')

				 );

								

		    $this->redirection_model->safe_insert('wps_redirection_tbl',$posted_data,FALSE);	

								

			$this->session->set_userdata(array('msg_type'=>'success'));			

			$this->session->set_flashdata('success',lang('success'));				

			redirect('wps-admin/redirection', '');		

					

		}	

		$this->load->view('redirection/view_redirection_add',$data);		  

		  

	}

	

	

	public function edit()

	{


		$redirectionId = (int) $this->uri->segment(4);

$rowdata=$this->redirection_model->get_redirection_by_id($redirectionId);
		

		$data['headingTitle'] = 'Edit Redirection Urls';

		if( !is_array($rowdata) )

		{

			$this->session->set_flashdata('message', lang('idmissing'));	

			redirect('wps-admin/redirection', ''); 	

			

		}

		$redirectionId = $rowdata['id'];

		
			$this->form_validation->set_rules('old_url','Old Url',"trim|required");



			$this->form_validation->set_rules('new_url','New Url',"trim|required");

			 		

			

			if($this->form_validation->run()==TRUE)

			{	

				$posted_data = array(

					'old_url'=>$this->input->post('old_url'),

					'new_url'=>$this->input->post('new_url'),

					'updated_on'=>$this->config->item('config.date.time')

				 );

				 

			 	$where = "id = '".$redirectionId."'"; 				

				$this->redirection_model->safe_update('wps_redirection_tbl',$posted_data,$where,FALSE);	

							

				$this->session->set_userdata(array('msg_type'=>'success'));				

				$this->session->set_flashdata('success',lang('successupdate'));								



				redirect('wps-admin/redirection'.'/'.query_string(), ''); 	

							

			}						

			

		$data['edit_result']=$rowdata;	
		

		$this->load->view('redirection/view_redirection_edit',$data);				

		

	}

	

	

}

// End of controller