<?php

class Pages extends Public_Controller {

  public function __construct() {

    parent::__construct();
    $this->load->helper(array('file'));
    $this->load->library(array('Dmailer', 'safe_encrypt'));
    $this->load->model(array('pages/pages_model'));
    $this->form_validation->set_error_delimiters("<div class='required red'>", "</div>");
    $this->page_section_ct = 'static';
  }

  public function index() {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $this->load->view('pages/cms_page_view', $data);
  }

  public function aboutus() {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $data['heading'] = 'Top 5 Best Furniture Manufacturers Retailers in Bangalore';
    $this->load->view('pages/about', $data);
  }
public function paymentmethods() {
    $data = array();
    $this->load->view('pages/payment-methods', $data);
  }
  
  public function shippingworldwide() {
    $data = array();
    $this->load->view('pages/shipping-worldwide', $data);
  }
  public function payonline() {
    $data = array();
    $this->load->view('pages/pay-online', $data);
  }
  public function howtopay() {
    $data = array();
    $this->load->view('pages/how-to-pay', $data);
  }
  public function whatsappenq()  
    {
     $adminRes = get_site_email();
    $data['adminRes'] = $adminRes;
      $this->form_validation->set_rules('wname', 'Name', 'trim|required');
      $this->form_validation->set_rules('wmobile', 'Mobile Number', 'trim|required|max_length[10]|min_length[10]|numeric');
      $url=$_SERVER['HTTP_REFERER'];
        if ($this->form_validation->run() == TRUE) {  
        $posted_data = array (
          'type' => '3',
          'first_name' => $this->input->post('wname'),
          'mobile_number' => $this->input->post('wmobile'),
          'message' => 'Whatsapp Enquiry',
          'post_url' => $url,
          'receive_date' => $this->config->item('config.date.time')
        );
           
        $result = $this->pages_model->safe_insert('wps_enquiry', $posted_data, false);
            
          $subject = "WebpulseIndia.com - Whatsapp Enquiry from Dawakhanas";
          $content = get_content('wps_auto_respond_mails', '7');
          $body = $content->email_content;
          $body = str_replace('{mem_name}', 'Admin', $body);
          $body = str_replace('{name}', $this->input->post('wname'), $body);
          $body = str_replace('{phone}', $this->input->post('wmobile'), $body);
          $body = str_replace('{site_name}', $this->config->item('site_name'), $body);
          $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);
          $body = str_replace('{post_url}', $url, $body);
          $mail_conf = array(
              'subject' => $subject,
              'to_email' => $adminRes->admin_email,
              'reply_to' => 'enquiry@webpulseindia.com',
              'reply_name' => $this->input->post('wname'),
              'from_email' => 'enquiry@webpulseindia.com',
              'from_name' => $this->input->post('wname'),
              'body_part' => $body
          );
            
            //print_r($mail_conf);

       
          //Send the Mail To Client
          $this->dmailer->mail_notify($mail_conf);
            
       $res = 'success';     
    }
        else {
        $res = '<div class="alert alert-danger">
                        <strong>'.validation_errors().'
                    </div>';
      }
      echo $res;
      exit;
 
    }

  public function contactus() {
     
    $adminRes = get_site_email();
    $data['adminRes'] = $adminRes;
    $url =  $_SERVER['HTTP_REFERER'];
      if($_POST)  {
           if ($this->input->post('action') == 'postData') {
    $this->form_validation->set_rules('first_name', 'First Name', 'trim|required');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
    $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required|numeric|min_length[10]|max_length[10]');
    $this->form_validation->set_rules('message', 'Comment', 'trim|required');
    $this->form_validation->set_rules('city', 'City', 'trim|required');
    $this->form_validation->set_rules('state', 'State', 'trim|required');
    $this->form_validation->set_rules('country', 'Country', 'trim|required');
    $this->form_validation->set_rules('age', 'Age', 'trim|required|min_length[1]|max_length[2]');
    $this->form_validation->set_rules('gender', 'Gender', 'trim|required');
    $this->form_validation->set_rules('marital', 'Marital', 'trim|required');
    if ($this->form_validation->run() == TRUE) {
        
        
         $tRap = $this->input->post('tRap');
        if ($tRap) {
          redirect(base_url('contact-us'));
          exit;
        }

      $posted_data = array(
          'type' => '1',
          'first_name' => $this->input->post('first_name'),
          'age' => $this->input->post('age'),
          'gender' => $this->input->post('gender'),
          'marital' => $this->input->post('marital'),
          'city' => $this->input->post('city'),
          'email' => $this->input->post('email'),
          'mobile_number' => $this->input->post('phone'),
          'country' => $this->input->post('country'),
          'state' => $this->input->post('state'),
          'message' => $this->input->post('message'),
          'post_url' => $url,
          'receive_date' => $this->config->item('config.date.time')
      );
      $result = $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);
      //Mail
      $content = get_content('wps_auto_respond_mails', '5');
      $name = $this->input->post('first_name');
      $body = $content->email_content;
      $body = str_replace('{mem_name}', 'Admin', $body);
      $body = str_replace('{user_name}', $name, $body);
      $body = str_replace('{email}', $this->input->post('email'), $body);
      $body = str_replace('{phone}', $this->input->post('phone'), $body);
      $body = str_replace('{age}', $this->input->post('age'), $body);
      $body = str_replace('{gender}', $this->input->post('gender'), $body);
      $body = str_replace('{marital}', $this->input->post('marital'), $body);
      $body = str_replace('{city}', $this->input->post('city'), $body);
       $body = str_replace('{state}', $this->input->post('state'), $body);
        $body = str_replace('{country}', $this->input->post('country'), $body);
      $body = str_replace('{comments}', $this->input->post('message'), $body);
      $body = str_replace('{site_name}', SITENAME, $body);
      $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);
      if($adminRes->mode=='Live'){
          $mail_conf = array(
              'subject' => "Enquiry from DawaKhana",
              'to_email' => $adminRes->admin_email,
              'from_email' => $this->input->post('email'),
              'from_name' => $name,
              'body_part' => $body
          );
          $this->dmailer->mail_notify($mail_conf);
        
          
          $mail_conf = array(
              'subject' => "Enquiry from DawaKhana",
              'to_email' => 'webpulseindia@gmail.com',
              'from_email' => $this->input->post('email'),
              'from_name' => $name,
              'body_part' => $body
          );
          $this->dmailer->mail_notify($mail_conf);
      }else{
          $mail_conf = array(
            'subject' => "Webpulseindia.com - Enquiry from DawaKhana",
            'to_email' => 'webpulseindia@gmail.com',
            'from_email' => $this->input->post('email'),
            'from_name' => $name,
            'body_part' => $body
          );
          $this->dmailer->mail_notify($mail_conf);
      }

        echo $res = "success"; exit();
    }
        else
        {
          echo $res = '<div class="alert alert-danger">
                        <strong>'.validation_errors().'
                    </div>'; exit();
        }
           
         
    }
      }
 

    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '14');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $data['title'] = "Contact Us";
    $this->load->view('contactus', $data);
  }
    
 //book-appointment
 public function appointment() {
     
  $adminRes = get_site_email();
  $data['adminRes'] = $adminRes;
  $url =  $_SERVER['HTTP_REFERER'];
    if($_POST)  {
         if ($this->input->post('action') == 'postData') {
  $this->form_validation->set_rules('first_name', 'First Name', 'trim|required');
  $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
  $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required|numeric|min_length[10]|max_length[12]');
  $this->form_validation->set_rules('message', 'Comment', 'trim|required');
  $this->form_validation->set_rules('city', 'City', 'trim|required');
  $this->form_validation->set_rules('state', 'State', 'trim|required');
  $this->form_validation->set_rules('country', 'Country', 'trim|required');
  $this->form_validation->set_rules('age', 'Age', 'trim|required|min_length[1]|max_length[2]');
  $this->form_validation->set_rules('gender', 'Gender', 'trim|required');
  $this->form_validation->set_rules('marital', 'Marital', 'trim|required');
  if ($this->form_validation->run() == TRUE) {
      
      
       $tRap = $this->input->post('tRap');
      if ($tRap) {
        redirect(base_url('book-appointment'));
        exit;
      }

    $posted_data = array(
        'type' => '1',
        'first_name' => $this->input->post('first_name'),
        'age' => $this->input->post('age'),
        'gender' => $this->input->post('gender'),
        'marital' => $this->input->post('marital'),
        'city' => $this->input->post('city'),
        'email' => $this->input->post('email'),
        'mobile_number' => $this->input->post('phone'),
        'country' => $this->input->post('country'),
        'state' => $this->input->post('state'),
        'message' => $this->input->post('message'),
        'post_url' => $url,
        'receive_date' => $this->config->item('config.date.time')
    );
    $result = $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);
    //Mail
    $content = get_content('wps_auto_respond_mails', '5');
    $name = $this->input->post('first_name');
    $body = $content->email_content;
    $body = str_replace('{mem_name}', 'Admin', $body);
    $body = str_replace('{user_name}', $name, $body);
    $body = str_replace('{email}', $this->input->post('email'), $body);
    $body = str_replace('{phone}', $this->input->post('phone'), $body);
    $body = str_replace('{age}', $this->input->post('age'), $body);
    $body = str_replace('{gender}', $this->input->post('gender'), $body);
    $body = str_replace('{marital}', $this->input->post('marital'), $body);
    $body = str_replace('{city}', $this->input->post('city'), $body);
     $body = str_replace('{state}', $this->input->post('state'), $body);
      $body = str_replace('{country}', $this->input->post('country'), $body);
    $body = str_replace('{comments}', $this->input->post('message'), $body);
    $body = str_replace('{site_name}', SITENAME, $body);
    $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);
    if($adminRes->mode=='Live'){
         $mail_conf = array(
             'subject' => "Enquiry from DawaKhana",
             'to_email' => $adminRes->admin_email,
             'from_email' => $this->input->post('email'),
             'from_name' => $name,
             'body_part' => $body
         );
         $this->dmailer->mail_notify($mail_conf);
       
        
        $mail_conf = array(
            'subject' => "Enquiry from DawaKhana",
            'to_email' => 'webpulseindia@gmail.com',
            'from_email' => $this->input->post('email'),
            'from_name' => $name,
            'body_part' => $body
        );
        $this->dmailer->mail_notify($mail_conf);
    }else{
        $mail_conf = array(
          'subject' => "Webpulseindia.com - Enquiry from DawaKhana",
          'to_email' => 'webpulseindia@gmail.com',
          'from_email' => $this->input->post('email'),
          'from_name' => $name,
          'body_part' => $body
        );
        $this->dmailer->mail_notify($mail_conf);
    }

      echo $res = "success"; exit();
  }
      else
      {
        echo $res = '<div class="alert alert-danger">
                      <strong>'.validation_errors().'
                  </div>'; exit();
      }
         
       
  }
    }


  $friendly_url = $this->uri->uri_string;
  $condition = array('friendly_url' => $friendly_url, 'status' => '14');
  $content = $this->pages_model->get_cms_page($condition);
  $data['content'] = $content;
  $data['title'] = "Book Appointment";
  $this->load->view('bookappointment', $data);
}   
    public function quickinquiry() {
     
    $adminRes = get_site_email();
    $data['adminRes'] = $adminRes;
    $url =  $_SERVER['HTTP_REFERER'];
      if($_POST)  {
           if ($this->input->post('action') == 'postData') {
    $this->form_validation->set_rules('first_name', 'First Name', 'trim|required');
    $this->form_validation->set_rules('last_name', 'First Name', 'trim|required');
    $this->form_validation->set_rules('city', 'Location', 'trim|required');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
    $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required|numeric|min_length[10]|max_length[10]');
    $this->form_validation->set_rules('message', 'Comment', 'trim|required');
    $this->form_validation->set_rules('subject', 'Comment', 'trim|required');
    if ($this->form_validation->run() == TRUE) {
        
         $tRap = $this->input->post('tRap');
        if ($tRap) {
          redirect(base_url());
          exit;
        }

      $posted_data = array(
          'type' => '1',
          'first_name' => $this->input->post('first_name'),
          'last_name' => $this->input->post('last_name'),
          'location' => $this->input->post('city'),
          'email' => $this->input->post('email'),
          'mobile_number' => $this->input->post('phone'),
          'purpose' => $this->input->post('subject'),
          'message' => $this->input->post('message'),
            'post_url' => $url,
          'receive_date' => $this->config->item('config.date.time')
      );
      $result = $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);
      //Mail
      $content = get_content('wps_auto_respond_mails', '5');
      $name = $this->input->post('first_name');
      $body = $content->email_content;
      $body = str_replace('{mem_name}', 'Admin', $body);
      $body = str_replace('{user_name}', $name, $body);
      $body = str_replace('{email}', $this->input->post('email'), $body);
      $body = str_replace('{phone}', $this->input->post('phone'), $body);
      $body = str_replace('{location}', $this->input->post('location'), $body);
      $body = str_replace('{comments}', $this->input->post('message'), $body);
      $body = str_replace('{site_name}', SITENAME, $body);
      $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);
      if($this->admin_info->website_mode=='Live'){
          $mail_conf = array(
              'subject' => "Enquiry from DawaKhana",
              'to_email' => $adminRes->admin_email,
              'from_email' => $this->input->post('email'),
              'from_name' => $name,
              'body_part' => $body
          );
          $this->dmailer->mail_notify($mail_conf);
      }

        echo $res = "success"; exit();
    }
        else
        {
          echo $res = '<div class="alert alert-danger">
                        <strong>'.validation_errors().'
                    </div>'; exit();
        }
         
    }
      }
 
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '14');
    $data['title'] = "Quick Inquiry";
    $this->load->view('viewquick', $data);
  }
    
    

  public function marketarea() {
    $data = array();

    $data['country'] = $this->db->query("SELECT id, name, country_temp_name, status FROM wps_countries_list WHERE status ='1'")->result_array();

    $data['state'] = $this->db->query("SELECT id, name, country_id, temp_title, status FROM wps_states_list WHERE status ='1'")->result_array();

    $this->load->view('marketarea', $data);
  }

    
    public function quickcontact()
    {
    $adminRes = get_site_email();
    $data['adminRes'] = $adminRes;
    $url =  $_SERVER['HTTP_REFERER'];
     if ($this->input->post('action') == 'postData') {
     $this->form_validation->set_rules('first_name', 'First Name', 'trim|required');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
    $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required|numeric|min_length[10]|max_length[10]');
    $this->form_validation->set_rules('message', 'Comment', 'trim|required');
    $this->form_validation->set_rules('city', 'City', 'trim|required');
    $this->form_validation->set_rules('state', 'State', 'trim|required');
    $this->form_validation->set_rules('country', 'Country', 'trim|required');
    $this->form_validation->set_rules('age', 'Age', 'trim|required');
    $this->form_validation->set_rules('gender', 'Gender', 'trim|required');
    $this->form_validation->set_rules('marital', 'Marital', 'trim|required');
        if($this->form_validation->run() == TRUE){
             $tRap = $this->input->post('tRap');
        if ($tRap) {
          redirect(base_url());
          exit;
        }
         $url=$_SERVER['HTTP_REFERER'];
        $posted_data = array(
          'type' => '1',
          'first_name' => $this->input->post('first_name'),
          'age' => $this->input->post('age'),
          'gender' => $this->input->post('gender'),
          'marital' => $this->input->post('marital'),
          'city' => $this->input->post('city'),
          'email' => $this->input->post('email'),
          'mobile_number' => $this->input->post('phone'),
          'country' => $this->input->post('country'),
          'state' => $this->input->post('state'),
          'message' => $this->input->post('message'),
          'post_url' => $url,
          'receive_date' => $this->config->item('config.date.time')
      );
      
      $result=$this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);
      
    $subject = "WebpulseIndia.com - Quick Contact from DawaKhana";
    $content = get_content('wps_auto_respond_mails', '5');
    $body = $content->email_content;
    $body = str_replace('{mem_name}', 'Admin', $body);
    $body = str_replace('{user_name}', $this->input->post('first_name'), $body);
    $body = str_replace('{email}', $this->input->post('email'), $body);
    $body = str_replace('{phone}', $this->input->post('phone'), $body);
    $body = str_replace('{age}', $this->input->post('age'), $body);
    $body = str_replace('{gender}', $this->input->post('gender'), $body);
    $body = str_replace('{marital}', $this->input->post('marital'), $body);
    $body = str_replace('{city}', $this->input->post('city'), $body);
    $body = str_replace('{state}', $this->input->post('state'), $body);
    $body = str_replace('{country}', $this->input->post('country'), $body);
    $body = str_replace('{comments}', $this->input->post('message'), $body);
    $body = str_replace('{site_name}',SITENAME, $body);
    $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);
               if($adminRes->mode=='Live'){
          $mail_conf = array(
              'subject' => "Enquiry from DawaKhana",
              'to_email' => $adminRes->admin_email,
              'from_email' => $this->input->post('email'),
              'from_name' => $name,
              'body_part' => $body
          );
          $this->dmailer->mail_notify($mail_conf);
          $mail_conf = array(
              'subject' => "Enquiry from DawaKhana",
              'to_email' => 'webpulseindia@gmail.com',
              'from_email' => $this->input->post('email'),
              'from_name' => $name,
              'body_part' => $body
          );
          $this->dmailer->mail_notify($mail_conf);
      }else{
          $mail_conf = array(
            'subject' => "Webpulseindia.com - Enquiry from DawaKhana",
            'to_email' => 'webpulseindia@gmail.com',
            'from_email' => $this->input->post('email'),
            'from_name' => $name,
            'body_part' => $body
          );
          $this->dmailer->mail_notify($mail_conf);
      }
 
          $res = 'success';     
    }
        else {
        $res = '<div class="alert alert-danger">
                        <strong>'.validation_errors().'
                    </div>';
      }
      echo $res;
    }
    }

    

    public function bookappointment() {
     
      $adminRes = get_site_email();
      $data['adminRes'] = $adminRes;
      $url =  $_SERVER['HTTP_REFERER'];
        if($_POST)  {
      $this->form_validation->set_rules('first_name', 'First Name', 'trim|required');
      $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
      $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required|numeric|min_length[10]|max_length[10]');
      $this->form_validation->set_rules('message', 'Comment', 'trim|required');
      $this->form_validation->set_rules('city', 'City', 'trim|required');
      $this->form_validation->set_rules('state', 'State', 'trim|required');
      $this->form_validation->set_rules('country', 'Country', 'trim|required');
      $this->form_validation->set_rules('age', 'Age', 'trim|required');
      $this->form_validation->set_rules('gender', 'Gender', 'trim|required');
      $this->form_validation->set_rules('marital', 'Marital', 'trim|required');
      if ($this->form_validation->run() == TRUE) {
  
        $posted_data = array(
            'type' => '1',
            'first_name' => $this->input->post('first_name'),
            'age' => $this->input->post('age'),
            'gender' => $this->input->post('gender'),
            'marital' => $this->input->post('marital'),
            'city' => $this->input->post('city'),
            'email' => $this->input->post('email'),
            'mobile_number' => $this->input->post('phone'),
            'country' => $this->input->post('country'),
            'state' => $this->input->post('state'),
            'message' => $this->input->post('message'),
            'post_url' => $url,
            'receive_date' => $this->config->item('config.date.time')
        );
        $result = $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);
        //Mail
        $content = get_content('wps_auto_respond_mails', '5');
        $name = $this->input->post('first_name');
        $body = $content->email_content;
        $body = str_replace('{mem_name}', 'Admin', $body);
        $body = str_replace('{user_name}', $name, $body);
        $body = str_replace('{email}', $this->input->post('email'), $body);
        $body = str_replace('{phone}', $this->input->post('phone'), $body);
        $body = str_replace('{location}', $this->input->post('city'), $body);
        $body = str_replace('{comments}', $this->input->post('message'), $body);
        $body = str_replace('{site_name}', SITENAME, $body);
        $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);
        if($this->admin_info->website_mode=='Live'){
            $mail_conf = array(
                'subject' => "Enquiry from DawaKhana",
                'to_email' => $adminRes->admin_email,
                'from_email' => $this->input->post('email'),
                'from_name' => $name,
                'body_part' => $body
            );
            $this->dmailer->mail_notify($mail_conf);
            $mail_conf = array(
                'subject' => "Enquiry from DawaKhana",
                'to_email' => 'webpulseindia@gmail.com',
                'from_email' => $this->input->post('email'),
                'from_name' => $name,
                'body_part' => $body
            );
            $this->dmailer->mail_notify($mail_conf);
        }else{
            $mail_conf = array(
              'subject' => "Webpulseindia.com - Enquiry from DawaKhana",
              'to_email' => 'test.webpulse@gmail.com',
              'from_email' => $this->input->post('email'),
              'from_name' => $name,
              'body_part' => $body
            );
            $this->dmailer->mail_notify($mail_conf);
        }
  
          echo $res = "success"; exit();
      }
          else
          {
            echo $res = '<div class="alert alert-danger">
                          <strong>'.validation_errors().'
                      </div>'; exit();
          }
             
           
      }
      $data['title'] = "Book Online Appointment";
      $this->load->view('bookappointment', $data);
    }


  public function whychoose() {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $this->load->view('pages/whychoose', $data);
  }


  public function sitemap() {
    $data['title'] = "Sitemap";
    $this->load->view('pages/sitemap',$data);
  }
    
     public function faq() {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $data['heading'] = 'Faq';
    $this->load->view('pages/faq_view', $data);
  }
    
      public function photo_gallery() {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['photogallery'] = $this->db->query("SELECT * FROM wps_gallery WHERE status = '1' ORDER BY gallery_id")->result_array();
      $data['heading'] = 'Photo gallery';
    $this->load->view('pages/view_gallery', $data);
  }


    public function video_gallery() {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['Videogallery'] = $this->db->query("SELECT * FROM wps_videos WHERE status = '1' ORDER BY id")->result_array();
      $data['heading'] = 'Video gallery';
    $this->load->view('pages/video_gallery', $data);
  }


   public function check_delivery($pin_code) {
  
    $pin_code = $this->db->query('select * from delivery_pincode_list where pincode=?', array($pin_code))->row();
    if ($pin_code) {
      echo '<div class="alert-success delivery-msg"><b><sup>* </sup>Delivery Available</b></div>';
     
    } else {
      echo '<div class="alert-danger delivery-msg"><b><sup>* </sup>Delivery Not Available</b></div>';
    }
  }
  
}

/* End of file pages.php */