<?php

class Members extends Private_Controller {

  private $mId;

  public function __construct() {
    parent::__construct();
    $this->load->model(array('members/members_model', 'order/order_model', 'products/product_model'));
    $this->load->helper(array('cart/cart', 'products/product'));
    $this->load->library(array('safe_encrypt', 'Dmailer', 'cart'));
    $this->form_validation->set_error_delimiters("<div class='required red'>", "</div>");
  }

  public function index() {
    redirect('members/myaccount', '');
  }

  public function myaccount() {
    $config['per_page'] = $this->config->item('per_page');
    $offset = $this->uri->segment(3, 0);
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    //My Recent Orders
    //and (payment_status='Paid' Or payment_method='Cash' Or payment_method='COD')
    $condtion = "AND customers_id = '" . $this->userId . "'  ";
    $res_array = $this->order_model->get_orders('0', '3', $condtion);
    $data['orders'] = $res_array;


    $data['title'] = "My Recent Orders";
    $this->load->view('view_member_myaccount', $data);
  }

  public function order_details() {
    $id = (int) $this->uri->segment(3);
    $order_res = $this->order_model->get_order_master($id);
    $order_details_res = $this->order_model->get_order_detail($id);

    $data['order_res'] = $order_res;
    $data['order_details'] = $order_details_res;

    $this->load->view('members/view_order_details', $data);
  }

  public function remove_wishlist() {
    $wish_id = (int) $this->uri->segment(3);

    if ($wish_id > 0) {
      $record = count_record('wps_wishlists', "id ='" . $wish_id . "'");
      if ($record > 0) {
        $this->db->query("DELETE FROM wps_wishlists WHERE id = '" . $wish_id . "'");
        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', "Product removed from wishlist.");
      } else {
        $this->session->set_userdata(array('msg_type' => 'warning'));
        $this->session->set_flashdata('warning', "Something went wrong, please try again!");
      }
    } else {
      $this->session->set_userdata(array('msg_type' => 'warning'));
      $this->session->set_flashdata('warning', "Wishlist product not found!");
    }
    redirect($_SERVER['HTTP_REFERER']);
  }

  public function cancel_order() {
    $orderid = (int) $this->uri->segment(3);
      $cancelDate = $this->config->item('config.date.time');
    if ($orderid > 0) {
      $this->db->query("UPDATE wps_order SET order_status = '5', order_cancelled_date = '$cancelDate' WHERE order_id = '" . $orderid . "'");

      //update stock
//      $where = "order_id = '" . $orderid . "' ";
//      $orders = $this->db->query("SELECT store, products_id, quantity FROM wps_orders_products WHERE " . $where)->result_array();
//      foreach ($orders as $ord) {
//        $qty = $ord['quantity'];
//        $this->db->query("UPDATE wps_product_attributes SET quantity=quantity+$qty WHERE store_id = '" . $ord['store'] . "' AND product_id = '" . $ord['products_id'] . "'");
//      }
      //End here

      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', "Your Order has been canceled successfully!");
    } else {
      $this->session->set_userdata(array('msg_type' => 'error'));
      $this->session->set_flashdata('error', "Incorrect Order ID, Please try again!");
    }
    redirect($_SERVER['HTTP_REFERER']);
  }

  public function edit_account() {
    $data['unq_section'] = "Myaccount";
    $data['title'] = "Edit Account";
    $data['titleArray'] = $this->config->item('titleArray');
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    //trace($mres);
    if (is_array($mres) && !empty($mres)) {
      $this->form_validation->set_rules('first_name', 'First Name', 'trim|required|alpha|max_length[160]');
        $this->form_validation->set_rules('email', 'Email', 'trim|required');
        $this->form_validation->set_rules('address', 'Address', 'trim|required');
        $this->form_validation->set_rules('country', 'Country', 'trim|required');
        $this->form_validation->set_rules('state', 'State', 'trim|required');
        $this->form_validation->set_rules('city', 'City', 'trim|required');
        $this->form_validation->set_rules('pincode', 'Pin Code', 'trim|required');
        $this->form_validation->set_rules('mobile_number', 'Mobile No.', 'trim|required|max_length[20]|min_length[10]');
      if ($this->form_validation->run() == TRUE) {
        $posted_user_data = array(
            'first_name' => $this->input->post('first_name'),
            'mobile_number' => $this->input->post('mobile_number'),
            'email' => $this->input->post('email'),
            'user_name' => $this->input->post('email'),
        );
           $where = "customers_id = '" . $mres['customers_id'] . "'";
          $this->members_model->safe_update('wps_customers', $posted_user_data, $where, FALSE);
          $posted_user_data2 = array(
            'first_name' => $this->input->post('first_name'),
            'mobile' => $this->input->post('mobile_number'),
            'country' => $this->input->post('country'),
            'state' => $this->input->post('state'),
            'city' => $this->input->post('city'),
            'address' => $this->input->post('address'),
            'zipcode' => $this->input->post('pincode'),
        );
        $where2 = "customer_id = '" . $mres['customers_id'] . "'";
        $this->members_model->safe_update('wps_customers_address_book', $posted_user_data2, $where2, FALSE);
        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', 'Account has been updated successfully!!!');
        redirect('members/edit_account', 'refresh');
      }
    } else {
      redirect('members', '');
    }


    $data['mres'] = $mres;
    $this->load->view('view_member_edit_account', $data);
  }

  public function change_password() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;
    $this->form_validation->set_rules('old_password', 'Old Password', 'trim|required');
    $this->form_validation->set_rules('new_password', 'New Password', 'trim|required|valid_password');
    $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'trim|required|matches[new_password]');

    if ($this->form_validation->run() == TRUE) {
      $password_old = $this->input->post('old_password', TRUE); 
      $mres = $this->members_model->get_member_row($this->userId, " AND password='$password_old' ");
      if (is_array($mres) && !empty($mres)) {
          $password = $this->input->post('new_password', TRUE);
          if($password_old != $password)
          {
        $data = array('password' => $password);
        $where = "customers_id=" . $this->session->userdata('user_id') . " ";
        $this->members_model->safe_update('wps_customers', $data, $where, FALSE);
        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', ' Password has been changed successfully.');
          }
          else{
              $this->session->set_userdata(array('msg_type' => 'error'));
            $this->session->set_flashdata('error', 'New Password same as your current password.');
          }
      } else {
        $this->session->set_userdata(array('msg_type' => 'error'));
        $this->session->set_flashdata('error', ' Old Password is not valid.');
      }
      redirect('members/change_password', '');
    }
    /* End  member change password  */
    $data['unq_section'] = "Myaccount";
    $data['heading_title'] = "Account Settings";
    $this->load->view('members/view_member_change_password', $data);
  }

  public function mywishlist() {
    $data['mres'] = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['wishlist'] = $this->members_model->get_wislists(NULL, NULL, array());
    //echo_sql();
    $data['total_records'] = get_found_rows();
    $this->load->view('members/view_member_wishlist', $data);
  }

  public function remove_wislist() {
    $wishlists_id = $ordId = $this->uri->segment(3);
    if ($wishlists_id != '') {

      $where = array('id' => $wishlists_id, 'customer_id' => $this->userId);
      $this->members_model->safe_delete('wps_wishlists', $where, FALSE);

      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', $this->config->item('wish_list_delete'));
      redirect('members/mywishlist', '');
    }
  }

  public function orders_history() {
    $data['unq_section'] = "Myaccount";
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    //get orders
    $record_per_page = (int) $this->input->post('per_page');
    $config['per_page'] = 2; //$this->config->item('per_page');
    $page_segment = find_paging_segment();
    $offset = (int) $this->uri->segment($page_segment, 0);
    //conditions
    $condtion = "AND customers_id = '" . $this->userId . "'";
    if ($this->input->post('order_id') != '') {
      $condtion .= "AND invoice_number = '" . $this->input->post('order_id') . "' ";
    }
    if ($this->input->post('start_date') != '') {
      $condtion .= "AND order_received_date >= '" . $this->input->post('start_date') . "' ";
    }
    if ($this->input->post('end_date') != '') {
      $condtion .= "AND order_received_date <= '" . $this->input->post('end_date') . "' ";
    }
    if ((int) $this->uri->segment(3, 0) == TRUE) {
      $condtion .= "AND order_id = '" . $this->uri->segment(3) . "' ";
    }

    $base_url = "members/orders_history/index/pg/";
    $res_array = $this->order_model->get_orders($offset, $config['per_page'], $condtion);
    $config['total_rows'] = $data['total_list_rows'] = $this->order_model->total_rec_found;
    $data['orders'] = $res_array;
    $this->load->view('view_member_orders', $data);
  }

  public function ajax_load_orders() {
    //get orders
    $config['per_page'] = $this->config->item('per_page');
    $offset = $this->input->get_post('stOffSet');
    $condtion = "AND customers_id = '$this->userId' ";
    if ($this->input->post('order_id') != '') {
      $condtion .= "AND invoice_number = '" . $this->input->post('order_id') . "' ";
    }
    if ($this->input->post('start_date') != '') {
      $condtion .= "AND order_received_date >= '" . $this->input->post('start_date') . "' ";
    }
    if ($this->input->post('end_date') != '') {
      $condtion .= "AND order_received_date <= '" . $this->input->post('end_date') . "' ";
    }
    if ((int) $this->uri->segment(3, 0) == TRUE) {
      $condtion .= "AND order_id = '" . $this->uri->segment(3) . "' ";
    }
    $res_array = $this->order_model->get_orders($offset, $config['per_page'], $condtion);
    $config['total_rows'] = $data['total_list_rows'] = $this->order_model->total_rec_found;
    $data['orders'] = $res_array;
    $this->load->view('view_member_orders_ajax', $data);
  }

  public function manage_addresses() {
    $customer_id = $this->session->userdata('user_id');

    $record_per_page = (int) $this->input->post('per_page');
    $parent_segment = (int) $this->uri->segment(3);
    $page_segment = find_paging_segment();

    $config['per_page'] = ( $record_per_page > 0 ) ? $record_per_page : $this->config->item('per_page');
    $offset = (int) $this->uri->segment($page_segment, 0);

    $parent_id = ( $parent_segment > 0 ) ? $parent_segment : '0';
    $base_url = ( $parent_segment > 0 ) ? "members/manage_addresses/$parent_id/pg/" : "members/manage_addresses/pg/";


    $address_res = $this->members_model->get_member_address_book($customer_id, $offset, $config['per_page']);
    $config['total_rows'] = $this->members_model->total_rec_found;
    $data['page_links'] = front_pagination("$base_url", $config['total_rows'], $config['per_page'], $page_segment);

    $data['address_res'] = $address_res;
    $data['heading'] = "Manage Addresses";
    $this->load->view('view_member_addresses', $data);
  }

  public function manage_addresses_add() {

    $this->form_validation->set_rules('name', 'Name', 'trim|required|alpha|max_length[80]');
    $this->form_validation->set_rules('mobile', 'Mobile No.', 'trim|required|max_length[20]');
    $this->form_validation->set_rules('phone', 'Phone No.', 'trim|max_length[20]');
    $this->form_validation->set_rules('zipcode', 'Pin Code', 'trim|required|max_length[20]');
    $this->form_validation->set_rules('address', 'Address', 'trim|required|max_length[200]');
    $this->form_validation->set_rules('landmark', 'Landmark', 'trim|required|max_length[200]');
    $this->form_validation->set_rules('city', 'City', 'trim|required|max_length[40]');
    $this->form_validation->set_rules('state', 'State', 'trim|required|max_length[40]');
    $this->form_validation->set_rules('country', 'Country', 'trim|required|max_length[80]');

    if ($this->form_validation->run() == TRUE) {
      $data = array(
          'customer_id' => $this->session->userdata('user_id'),
          'name' => $this->input->post('name'),
          'mobile' => $this->input->post('mobile'),
          'phone' => $this->input->post('phone'),
          'zipcode' => $this->input->post('zipcode'),
          'address' => $this->input->post('address'),
          'landmark' => $this->input->post('landmark'),
          'city' => $this->input->post('city'),
          'state' => $this->input->post('state'),
          'country' => $this->input->post('country'),
          'default_status' => 'Y'
      );
      //trace($data);
      //exit;
      $this->members_model->safe_insert('wps_customers_address_book', $data, FALSE);
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'New Address has been added successfully!!!');
      redirect('members/manage_addresses_add', '');
    }

    /* End  member change password  */

    $data['unq_section'] = "Myaccount";
    $data['heading_title'] = "Account Settings";
    $this->load->view('members/view_address_add', $data);
  }

  public function manage_addresses_edit() {

    //$addressid     = (int) $this->uri->segment(3);
    //$res=$this->db->query("select * from wps_customers_address_book where address_id='".$addressid."'")->row_array();

    $this->form_validation->set_rules('add_name', 'Name', 'trim|required|alpha|max_length[80]');
    $this->form_validation->set_rules('add_mobile', 'Mobile No.', 'trim|required|max_length[20]');

    $this->form_validation->set_rules('add_zipcode', 'Pin Code', 'trim|required|max_length[20]');
    $this->form_validation->set_rules('add_address', 'Address', 'trim|required|max_length[200]');
    $this->form_validation->set_rules('add_landmark', 'Landmark', 'trim|required|max_length[200]');
    $this->form_validation->set_rules('add_city', 'City', 'trim|required|max_length[40]');
    $this->form_validation->set_rules('add_state', 'State', 'trim|required|max_length[40]');
    $this->form_validation->set_rules('add_country', 'Country', 'trim|required|max_length[80]');

    if ($this->form_validation->run() == TRUE) {
      $data = array(
          'name' => $this->input->post('add_name'),
          'mobile' => $this->input->post('add_mobile'),
          'phone' => $this->input->post('add_mobile'),
          'zipcode' => $this->input->post('add_zipcode'),
          'address' => $this->input->post('add_address'),
          'landmark' => $this->input->post('add_landmark'),
          'city' => $this->input->post('add_city'),
          'state' => $this->input->post('add_state'),
          'country' => $this->input->post('add_country'),
      );
      //trace($data);
      //exit;
      $where = array('customer_id' => $this->session->userdata('user_id'));
      $this->members_model->safe_update('wps_customers_address_book', $data, $where, FALSE);
      $this->session->set_userdata(array('msg_type' => 'success'));
      echo 2;
      //$this->session->set_flashdata('success', 'New Address has been updated successfully!!!');
      //redirect('members/manage_addresses_edit/' . $addressid, '');
    } else {
      echo validation_errors();
      die;
    }

    /* End  member change password  */
    /* $data['res'] = $res;
      //trace($res);
      $data['unq_section'] = "Myaccount";
      $data['heading_title'] = "Account Settings";
      $this->load->view('members/view_address_edit',$data); */
  }

  public function delete_address() {
    $addressid = (int) $this->uri->segment(3);
    $this->db->query("delete from wps_customers_address_book where address_id = '" . $addressid . "'");
    $this->session->set_userdata(array('msg_type' => 'success'));
    $this->session->set_flashdata('success', 'Address has been Deleted successfully!!!');
    redirect($_SERVER['HTTP_REFERER']);
  }

  public function post_review_old() {
    $productId = (int) $this->uri->segment(3);
    $data['proRes'] = get_db_single_row("wps_products", "*", "products_id = '" . $productId . "'");
    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");
    $data['mres'] = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $this->form_validation->set_rules('ads_rating', 'Rating', 'trim|required|max_length[1]');
    $this->form_validation->set_rules('comment', 'Review', 'trim|required|max_length[450]');
    if ($this->form_validation->run() === TRUE) {
      $mem_id = $this->session->userdata('user_id');
      $posted_data = array(
          'product_id' => $this->input->post('products_id'),
          'entity_type' => 'product',
          'customer_id' => $this->session->userdata('user_id'),
          'ads_rating' => $this->input->post('ads_rating'),
          'author' => $this->session->userdata('fullname'),
          'author_email' => $this->session->userdata('username'),
          'text' => $this->input->post('comment'),
          'status' => '0',
          'review_date' => $this->config->item('config.date.time')
      );
      $this->product_model->safe_insert('wps_review', $posted_data, FALSE);
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Thank you. Your review has been submitted successfully');
      redirect('members/post_review/' . $data['proRes']['products_id'], '');
    }
    $this->load->view('view_member_my_reviews', $data);
  }

  public function post_review() {
    $productId = (int) $this->uri->segment(3);
    $this->db->from('wps_order');
    $this->db->where('customers_id',$this->session->userdata('user_id'));
    $this->db->where('products_id',$productId);
    $this->db->join('wps_orders_products', 'wps_orders_products.order_id = wps_order.order_id', 'left');
    $query = $this->db->get();
    $productcount = $query->num_rows();
    $product = $query->row(); 
    $data['proRes'] = get_db_single_row("wps_products", "*", "products_id = '" . $product->products_id . "'");
    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");
    $data['mres'] = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $this->form_validation->set_rules('ads_rating', 'Rating', 'trim|required|max_length[1]');
    $this->form_validation->set_rules('comment', 'Review', 'trim|required|max_length[450]');
    if ($this->form_validation->run() === TRUE) {
      $mem_id = $this->session->userdata('user_id');
      //image section start
      $pic1 = '';
      if (!empty($_FILES) && $_FILES['img1']['name'] != '') {
        $this->load->library('upload');
        $config1['upload_path'] = UPLOAD_DIR . '/reviews/';
        $config1['allowed_types'] = 'gif|jpg|png|jpeg';
        $this->upload->initialize($config1);
        $uploaded_data = $this->upload->do_upload('img1');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $pic1 = $uploaded_data['upload_data']['file_name'];
        }
      }
      //image section end
      $posted_data = array(
          'entity_id' => $this->input->post('products_id'),
          'entity_type' => 'product',
          'customer_id' => $this->session->userdata('user_id'),
          'ads_rating' => $this->input->post('ads_rating'),
          'author' => $this->session->userdata('fullname'),
          'author_email' => $this->session->userdata('username'),
          'text' => $this->input->post('comment'),
          'upload_image' => $pic1,
          'status' => '0',
          'review_date' => $this->config->item('config.date.time')
      );

      $this->product_model->safe_insert('wps_review', $posted_data, FALSE);
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Thank you. Your review has been submitted successfully');
      redirect('members/post_review/' . $data['proRes']['products_id'], '');
    }
    if($productcount==0)
      {
        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('reviewstatus', 'You are not authorized to Review & rating the Product. Untill buy the Particular product');
        redirect($_SERVER['HTTP_REFERER']);  
      }
      else
      {
         $this->load->view('view_member_my_reviews', $data); 
      }
  }

  public function reviews_old() {
    $data['mres'] = $this->members_model->get_member_row($this->session->userdata('user_id'));

    $data['reviews'] = $this->db->query("SELECT * FROM  wps_review WHERE customer_id='" . $this->session->userdata('user_id') . "'")->result_array();
    $this->load->view('view_review', $data);
  }

  public function reviews() {
    $data['mres'] = $this->members_model->get_member_row($this->session->userdata('user_id'));

    $data['reviews'] = $this->db->query("SELECT * FROM  wps_review WHERE customer_id='" . $this->session->userdata('user_id') . "'")->result_array();
    //echo "<pre>";print_r($data);
    $this->load->view('view_review', $data);
  }

  public function edit_review_old() {
    $reviewId = (int) $this->uri->segment(3);
    $data['proRes'] = $this->db->query("SELECT * FROM  wps_review WHERE review_id='" . $reviewId . "'")->result_array();
    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");
    $data['mres'] = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $this->form_validation->set_rules('ads_rating', 'Rating', 'trim|required|max_length[1]');
    $this->form_validation->set_rules('comment', 'Review', 'trim|required|max_length[450]');
    if ($this->form_validation->run() === TRUE) {
      $mem_id = $this->session->userdata('user_id');
      $update_data = array(
          'product_id' => $this->input->post('products_id'),
          'entity_type' => 'product',
          'customer_id' => $this->session->userdata('user_id'),
          'ads_rating' => $this->input->post('ads_rating'),
          'author' => $this->session->userdata('fullname'),
          'author_email' => $this->session->userdata('username'),
          'text' => $this->input->post('comment'),
          'status' => '0',
          'review_date' => $this->config->item('config.date.time')
      );
      $where = "review_id=" . $reviewId . " ";
      $this->members_model->safe_update('wps_review', $update_data, $where, FALSE);
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Thank you. Your review has been updated successfully');
      redirect('members/edit_review/' . $reviewId, '');
    }
    $this->load->view('edit_myreview', $data);
  }

  public function edit_review() {
    $reviewId = (int) $this->uri->segment(3);
    $data['proRes'] = $this->db->query("SELECT * FROM  wps_review WHERE review_id='" . $reviewId . "'")->result_array();
    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");
    $data['mres'] = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $this->form_validation->set_rules('ads_rating', 'Rating', 'trim|required|max_length[1]');
    $this->form_validation->set_rules('comment', 'Review', 'trim|required|max_length[450]');
    if ($this->form_validation->run() === TRUE) {
      $mem_id = $this->session->userdata('user_id');
      $update_data = array(
          'entity_id' => $this->input->post('products_id'),
          'entity_type' => 'product',
          'customer_id' => $this->session->userdata('user_id'),
          'ads_rating' => $this->input->post('ads_rating'),
          'author' => $this->session->userdata('fullname'),
          'author_email' => $this->session->userdata('username'),
          'text' => $this->input->post('comment'),
          'status' => '0',
          'review_date' => $this->config->item('config.date.time')
      );
      $where = "review_id=" . $reviewId . " ";
      $this->members_model->safe_update('wps_review', $update_data, $where, FALSE);
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Thank you. Your review has been updated successfully');
      redirect('members/edit_review/' . $reviewId, '');
    }
    $this->load->view('edit_myreview', $data);
  }

  public function remove_review_old() {
    $reviews_id = $ordId = $this->uri->segment(3);
    if ($reviews_id != '') {
      $where = array('review_id' => $reviews_id, 'customer_id' => $this->userId);
      $this->members_model->safe_delete('wps_review', $where, FALSE);
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', $this->config->item('wish_list_delete'));
      redirect('members/reviews', '');
    }
  }

  public function remove_review() {
    $reviews_id = $ordId = $this->uri->segment(3);
    if ($reviews_id != '') {
      $where = array('review_id' => $reviews_id, 'customer_id' => $this->userId);
      $this->members_model->safe_delete('wps_review', $where, FALSE);
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', $this->config->item('wish_list_delete'));
      redirect('members/reviews', '');
    }
  }

  public function feedback() {
    $data['mres'] = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $testimonials = $this->db->query("SELECT * FROM  wps_testimonial WHERE user_id='" . $this->session->userdata('user_id') . "'")->row_array();

    $this->form_validation->set_rules('feedback', 'Feedback', 'trim|required');

    if ($this->form_validation->run() == TRUE) {
      if (count($testimonials) > 0) {
        $data = array('testimonial_description' => $this->input->post('feedback'),);
        $where = "user_id=" . $this->session->userdata('user_id') . " ";
        $this->members_model->safe_update('wps_testimonial', $data, $where, FALSE);
        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', 'Feedback Updated successfully.');
      } else {
        $data = array('testimonial_description' => $this->input->post('feedback'), 'user_id' => $this->session->userdata('user_id'));
        $this->members_model->safe_insert('wps_testimonial', $data);
        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', 'Feedback Added successfully.');
      }

      redirect('members/feedback', '');
    }

    $data['feedback'] = $testimonials;
    $this->load->view('view_member_my_feedback', $data);
  }

  public function notify() {
    //  $this->load->model(array('order/order_model'));
    $wishId = (int) $this->uri->segment(3);
    $data['wishId'] = $wishId;

    $param = array('condition' => "&& wishlists_id='" . $wishId . "'");

    $res = $this->members_model->get_wislists(0, 1, $param);

    $this->form_validation->set_rules('message', 'Message', 'trim|max_length[250]');
    if ($this->form_validation->run() == TRUE) {
      $data = array(
          'message' => $this->input->post('message', FALSE),
          'notify' => '1'
      );

      $where = array(
          'wishlists_id' => $wishId
      );

      $this->members_model->safe_update('wps_wishlists', $data, $where, TRUE);
      //		$this->session->set_userdata('msg_type',$res['error_type']);
      $this->session->set_flashdata('success', 'Your Notification has been set sucessfully.');
      redirect('members/notify/' . $wishId, '');
    }

    $data['wish'] = $res[0];
    $this->load->view('view_product_notify', $data);
  }

  public function track_order() {
    $data['unq_section'] = "Track Order";

    $this->form_validation->set_rules('order_id', 'Order No', 'trim|required');

    if ($this->form_validation->run() == TRUE) {
      redirect('members/orders_history/' . $this->input->post('order_id'));
    }
    $this->load->view('view_track_order', $data);
  }

}

/* End of file member.php */
/* Location: .application/modules/member/member.php */