<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends Public_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('products/product_model', 'category/category_model', 'members/members_model'));
  }

  public function index() {
    //home category
    
     $data['home_cat'] = $this->db->query("SELECT category_image, category_name, friendly_url FROM wps_categories WHERE status = '1' AND home_cat = '1' limit 0,8 ")->result_array();
      $data['testimonial'] = $this->db->query("SELECT testimonial_image, designation, poster_name, testimonial_description FROM wps_testimonial WHERE status = '1'")->result_array();
      $data['theme_cat1'] = $this->db->query("SELECT category_image, category_name, friendly_url FROM wps_categories WHERE status = '1' AND is_theme = '1' limit 0,2 ")->result_array();
    $data['brands'] = $this->db->query("SELECT brand_name, brand_image FROM wps_brands WHERE status = '1' ")->result_array();
     //Not in Header and not in main category list
    $let_cat = array('field' => "*", 'condition' => "AND status='1' AND home_cat = '0' AND is_theme = '0' AND home_menu = '0' AND category_id != '1'", 'limit' => "6", 'debug' => FALSE);
    $leftCatResult = $this->category_model->getcategory($let_cat);
    $data['leftCat'] = $leftCatResult;
    
    //Theme category
    $theme_cat = array('field' => "*", 'condition' => "AND status='1' AND is_theme = '1'", 'limit' => "2", 'debug' => FALSE);
    
    $themeCatResult = $this->category_model->getcategory($theme_cat);
    $data['themeCat'] = $themeCatResult;

    $data['bottomBanner1'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_position = 'Index Bottom 1' AND status = '1'")->row_array();
    $data['bottomBanner2'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_position = 'Index Bottom 2' AND status = '1'")->row_array();
    $data['bottomBanner3'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_position = 'Index Bottom 3' AND status = '1'")->row_array();
    $data['bottomBanner4'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_position = 'Index Bottom 4' AND status = '1'")->row_array();
    $data['bottomBanner5'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_position = 'Index Bottom 5' AND status = '1'")->row_array();

    //Popular products
    $data['popular_products'] = $this->get_popular_product();
    $data['popular_products2'] = $this->get_popular_product2();

    //New Arrival products
    $data['new_products'] = $this->get_new_product();
    $data['cocktail_pro'] = $this->get_trendig_product();

    $content = "";
    $homeHeading = '';
    //Check if it is subdomain
    $uri_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    $uri_segments = explode('/', $uri_path);
    $st = $uri_segments[1];
    if (strstr($st, '.html')) {
      $st = substr($st, 0, -5);
    }

    $stArray = $this->db->query("SELECT meta_id, page_url FROM wps_meta_tags WHERE is_fixed='L' AND page_url='" . $st . "'")->row_array();
    if (is_array($stArray) & !empty($stArray)) {
      $locId = $stArray['meta_id'];
      $resprosub = $this->db->query("SELECT * FROM wps_subloccontent WHERE status = '1' AND FIND_IN_SET($locId,location_id)")->row();
      if (is_object($resprosub) && !empty($resprosub)) {
        $key1 = $resprosub->meta_key1;
        $key2 = $resprosub->meta_key2;
        $key3 = $resprosub->meta_key3;
        $content = str_replace('{location}', ucwords(locationName($st)), str_replace('{key3}', $key3, str_replace('{key2}', $key2, str_replace('{key1}', $key1, $resprosub->description))));
        $homeHeading = 'Top Sexologist in ' . ucwords(locationName($st)) . ' | Hakim Hari Kishan Lal (Dawakhana Clinic) In ' . ucwords(locationName($st));
         }
    } else {
      $content = get_db_field_value('wps_cms_pages', 'page_description', "WHERE page_id = '1'");
      $homeHeading = 'Top Sexologist in Delhi | Hakim Hari Kishan Lal (Dawakhana Clinic)';
        
    }
  
    $data['homeHeading'] = $homeHeading;
    $data['home'] = $content;

    //banners
    $data['banner'] = $this->db->query("SELECT * FROM wps_banners WHERE status = '1' AND banner_position = 'Index Slider' order by banner_id asc")->result_array();
    $data['mobilebanner'] = $this->db->query("SELECT * FROM wps_banners WHERE status = '1' AND banner_position = 'Index Slider' and mobile_banner!='' order by banner_id asc")->result_array();
    $data['photogallery'] = $this->db->query("SELECT * FROM wps_gallery WHERE status = '1' ORDER BY gallery_id asc limit 9")->result_array();

    $this->load->view('view_home', $data);
  }

  public function get_popular_product() {
    $condtion['status'] = '1';
    $condtion['where'] = "category_id = '1'";
    $condtion['orderby'] = 'products_id DESC';
    $product_list = $this->product_model->get_products('9', '0', $condtion);
    return $product_list;
  }

  public function get_popular_product2() {
    $condtion['status'] = '1';
    $condtion['where'] = "category_id = '2'";
    $condtion['orderby'] = 'products_id DESC';
    $product_list = $this->product_model->get_products('6', '0', $condtion);
    return $product_list;
  }

  public function get_new_product() {
    $condtion['status'] = '1';
    $condtion['where'] = "newarrival_product = '1'";
    //$condtion['orderby'] = 'products_id ASC';
    $product_list = $this->product_model->get_products('8', '0', $condtion);
    return $product_list;
  }

  public function get_offer_product() {
    $condtion['status'] = '1';
    // $condtion['where'] = "newarrival_product = '1'";
    //$condtion['orderby'] = 'products_id ASC';
    $product_list = $this->product_model->get_products('8', '0', $condtion);
    return $product_list;
  }

  public function get_trendig_product() {
    $condtion['status'] = '1';
    // $condtion['where'] = "newarrival_product = '1'";
    $condtion['orderby'] = 'products_id Desc';
    $product_list = $this->product_model->get_products('8', '0', $condtion);
    return $product_list;
  }

  public function submit_newslater() {

    $this->form_validation->set_rules('newsletter_email', 'Email', 'trim|required|valid_email');
    $email = $this->input->post('newsletter_email');
    $check_email = $this->db->query("select subscriber_email from wps_newsletters where subscriber_email ='$email' and status='1'")->row_array();
    $callback_email = $check_email['subscriber_email'];
    $callback_email = count($callback_email);

    if ($callback_email > 0) {
      $callback_error = "<div class='alert alert-info'>You are Already Registered With Newsletter Service</div>";
      echo $callback_error;
    } else {

      if ($this->form_validation->run() == TRUE) {

        $posted_data = array(
            'subscriber_email' => $this->input->post('newsletter_email'),
            'message' => 'Signup For Newsletter',
            'subscribe_date' => $this->config->item('config.date.time')
        );

        $result = $this->members_model->safe_insert('wps_newsletters', $posted_data, false);
        $subject = "WebpulseIndia.com - Signup For Newsletter from ZaikaCake";
        $content = get_content('wps_auto_respond_mails', '3');
        $body = $content->email_content;
        $body = str_replace('{mem_name}', 'Admin', $body);
        $body = str_replace('{news_email}', $this->input->post('newsletter_email'), $body);
        $body = str_replace('{date}', $this->config->item('config.date.time'), $body);
        $body = str_replace('{site_name}', $this->config->item('site_name'), $body);
        $mail_conf = array(
            'subject' => $subject,
            'to_email' => $this->input->post('newsletter_email'),
            'reply_to' => $this->input->post('newsletter_email'),
            //'reply_name' => $this->input->post('wname'),
            'from_email' => 'enquiry@webpulseindia.com',
            'from_name' => $this->input->post('newsletter_email'),
            'body_part' => $body
        );


        $this->dmailer->mail_notify($mail_conf);
        $res = 'success';
      } else {
        $res = '<div class="alert alert-danger">
      <strong>' . validation_errors() . '
      </div>';
      }
      echo $res;
      exit;
    }
  }

}
