<?php

class Faq_category extends Admin_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('faq_category/faq_category_model'));
    $this->config->set_item('menu_highlight', 'other management');
  }

  public function index() {

    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $res_array = $this->faq_category_model->get_faq_cat($config['limit'], $offset);
    $total_record = get_found_rows();
    $config['total_rows'] = $total_record;
    $data['page_links'] = admin_pagination($base_url, $config['total_rows'], $config['limit'], $offset);
    $data['res'] = $res_array;

    if ($this->input->post('status_action') != '') {
      $this->update_status('bl_faq_category', 'category_id');
    }

    $data['heading_title'] = 'Manage FAQ\'s Category';
    $data['pagelist'] = $res_array;
    $this->load->view('faq/view_faq_cat_list', $data);
  }

  public function add() {
    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'faq_answer'));
    $data['heading_title'] = 'Add FAQ Category';
    $this->form_validation->set_rules('faq_category', 'Category Name', 'trim|required|xss_clean|max_length[250]');


    if ($this->form_validation->run() == TRUE) {

      $posted_data = array(
          'name' => $this->input->post('faq_category', TRUE),
      );

      $this->faq_category_model->safe_insert('bl_faq_category', $posted_data, FALSE);
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', lang('success'));
      redirect('sitepanel/faq_category', '');
    }

    $this->load->view('faq/view_faq_cat_add', $data);
  }

  public function edit() {
    $data['heading_title'] = 'Edit FAQ Category';
    $Id = (int) $this->uri->segment(4);
    $res = $this->faq_category_model->get_faq_cat(1, 0, array('id' => $Id));

    if (is_array($res) && !empty($res)) {
      $this->form_validation->set_rules('faq_category', 'Category Name', 'trim|required|xss_clean|max_length[250]');

      if ($this->form_validation->run() == TRUE) {

        $posted_data = array(
            'name' => $this->input->post('faq_category', TRUE),
        );

        $where = "category_id = '" . $res['category_id'] . "'";
        $this->faq_category_model->safe_update('bl_faq_category', $posted_data, $where, FALSE);
        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', lang('successupdate'));

        redirect('sitepanel/faq_category/' . query_string(), '');
      }

      $data['res'] = $res;
      $this->load->view('faq/view_faq_cat_edit', $data);
    } else {

      redirect('sitepanel/faq_category', '');
    }
  }

}

//controllet end