<?php

class Enquiry extends Admin_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('enquiry_model'));
    $this->load->library(array('Dmailer', 'safe_encrypt'));
    $this->config->set_item('menu_highlight', 'manage enquiry');
  }
  public function get_enquiryInCsv($offset = '0', $per_page = '10', $condition = '') {

    $keyword = $this->db->escape_str(trim($this->input->get_post('keyword', TRUE)));
    $from_date = $this->db->escape_str(trim($this->input->get_post('from_date', TRUE)));
    $to_date = $this->db->escape_str(trim($this->input->get_post('to_date', TRUE)));
    $order_status = $this->input->get_post('order_status', TRUE);
     $sort_by = $this->db->escape_str(trim($this->input->get_post('sort_by', TRUE)));

   
    $condition = "order_status !='9' $condition ";

    if ($from_date != '' || $to_date != '') {

      $condition_date = array();
      $condition .= " AND (";
      if ($from_date != '') {
        $condition_date[] = "DATE(receive_date)>='$from_date'";
      }if ($to_date != '') {
        $condition_date[] = "DATE(receive_date)<='$to_date'";
      }

      $condition .= implode(" AND ", $condition_date) . " )";
    }
    // if ($order_status != '') {
    //   $condition .= " AND order_status = '" . $order_status . "'";
    // }
  
    // if ($keyword != '') {
    //   $condition .= " AND ( invoice_number LIKE '%" . $keyword . "%' OR  CONCAT_WS(' ',first_name,last_name) LIKE '%" . $keyword . "%' OR email LIKE '%" . $keyword . "%'  OR  payment_status LIKE '" . $keyword . "%' OR  total_amount LIKE '" . $keyword . "%' OR  payment_method LIKE '" . $keyword . "%' OR  tracking_code LIKE '" . $keyword . "%' ) ";
    // }
    // if ($sort_by != '') {
    //   $condition .= " AND (payment_status LIKE '" . $sort_by . "%' OR  payment_method LIKE '" . $sort_by . "%') ";
    // }

    $fetch_config = array(
        'condition' => $condition,
        'order' => 'id DESC',
        'limit' => $per_page,
        'start' => $offset,
        'debug' => FALSE,
        'return_type' => "array"
    );
    //$result = $this->findAll('wps_order', $fetch_config);
    //$this->db->select('*');
    $this->db->select('first_name,email,mobile_number,age,gender,marital,post_url,city,state,country,message');
   // $this->db->select("DATE_FORMAT( date, '%H:%i') as time_human",      FALSE );

    $this->db->from('wps_enquiry');

    //$this->db->where($fetch_config);


    $query = $this->db->get();

    if ( $query->num_rows() > 0 )
    {
        $row = $query->result_array();
       // return $row;
    }
    return $row;
  }
  public function export_totalenquiry_csv(){ 
    // file name 
    $filename = 'enquiry_'.date('Ymd').'.csv'; 
    header("Content-Description: File Transfer"); 
    header("Content-Disposition: attachment; filename=$filename"); 
    header("Content-Type: application/csv; ");
   // get data       
    //$ordId = (int) $this->uri->segment(4);
    $ordmaster = $this->get_enquiryInCsv();    
    if(!empty($ordmaster)){
    $file = fopen('php://output','w');
    $header = array("Name","Email","Mobile","Age","Gender","Marital","Url","City","State","Country","Comments");
    fputcsv($file, $header);
    foreach ($ordmaster as $key=>$line){ 
        fputcsv($file,$line); 
    }
    fclose($file); 
    exit; 
    }
}
  
  public function index() {
    $type = (int) $this->uri->segment(4);
    $keyword = trim($this->input->post('keyword', TRUE));
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $condition = "type = '" . $type . "'";
    $keyword = $this->db->escape_str($keyword);
    if ($keyword != '') {
      $condition .= " AND  ( email like '%$keyword%' OR  company_name like '%$keyword%' OR CONCAT_WS(' ',first_name,last_name) LIKE '%" . $keyword . "%' ) ";
    }

    $res_array = $this->enquiry_model->get_enquiry($offset, $config['limit'], $condition);

    $config['total_rows'] = $this->enquiry_model->total_rec_found;
    //$data['page_links'] = admin_pagination($base_url, $config['total_rows'], $config['limit'], $offset);

    if ($this->input->post('status_action') != '') {
      $this->update_status('wps_enquiry', 'id');
    }
    if ($type == 1) {
      $data['headingTitle'] = 'Manage Enquiry';
    }
    if ($type == 2) {
      $data['headingTitle'] = 'Manage Subscriptions';
    }
    if ($type == 3) {
      $data['headingTitle'] = 'Message From DDA Members';
    }
    if ($type == 4) {
      $data['headingTitle'] = 'Manage Product Enquiry';
    }
    if ($type == 5) {
      $data['headingTitle'] = 'Manage Complaint';
    }


    /* Product set as a */
    if ($this->input->post('action') != '') {
      $this->update_status('wps_enquiry', 'id');
    }
    /* End product set as a */

    $data['inq_type'] = 'General';
    $data['result'] = $res_array;
    //print_r($res_array);exit;
    if ($type == 2) {
      $this->load->view('enquiry/view_subscriber_list', $data);
    } else {
      $this->load->view('enquiry/view_enquiry_list', $data);
    }
  }

  public function sendReply() {
    $to = $this->input->post('to');
    $message = $this->input->post('message');
    $subject = $this->input->post('subject');
    if ($to) {
      //Mail
      $mail_conf = array(
          'subject' => $subject,
          'to_email' => $to,
          'from_email' => 'info@zaikacake.in',
          'from_name' => 'ZaikaCake',
          'body_part' => nl2br($message),
      );
      //trace($mail_conf);
      //exit;
      $this->dmailer->mail_notify($mail_conf);
      echo 'Reply Sent Successfully!';
      
    } else {
      echo 'Something went wrong! Please try later.';
    }
  }

}

// End of controller