<?php

class Blog extends Admin_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('blog/blog_model'));
    //$this->load->helper('blogcategory/blogcategory');
    $this->config->set_item('menu_highlight', 'manage blog');
  }

  public function index($page = NULL) {
  if ($this->session->userdata('adm_key') != "1") {
            redirect('wps-admin/dashboard', 'refresh');
          }
    $condtion = array();
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $status = $this->input->get_post('status', TRUE);
    if ($status != '') {
      $condtion['status'] = $status;
    }

    $res_array = $this->blog_model->get_blog($config['limit'], $offset, $condtion);
    //echo_sql();
    $config['total_rows'] = get_found_rows();
    $data['heading_title'] = 'Blog Lists';
    $data['res'] = $res_array;
   // $data['page_links'] = admin_pagination($base_url, $config['total_rows'], $config['limit'], $offset);

    if ($this->input->post('action') != '') {
      $this->update_status('wps_blog', 'article_id');
    }

    /* Product set as a */

    if ($this->input->post('set_as') != '') {
      $set_as = $this->input->post('set_as', TRUE);
      $this->set_as('wps_blog', 'article_id', array($set_as => '1'));
    }

    if ($this->input->post('unset_as') != '') {
      $unset_as = $this->input->post('unset_as', TRUE);
      $this->set_as('wps_blog', 'article_id', array($unset_as => '0'));
    }
    /* End product set as a */
    $data['category_result_found'] = "Total " . $config['total_rows'] . " result(s) found ";

    $this->load->view('blogs/view_blog_list', $data);
  }

  public function add() {
      //echo "heloo";die;
    $seo_url_length = $this->config->item('seo_url_length');
    $data['heading_title'] = 'Add Blog';
    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'article_desc'));

    $this->form_validation->set_rules('article_title', 'Title', "trim|required|max_length[200]");
    $this->form_validation->set_rules('blog_author', 'Author Name', "trim|required|alpha|max_length[80]");
    $this->form_validation->set_rules('short_desc', 'Short Description', "trim|required|max_length[450]");
    $this->form_validation->set_rules('article_desc', 'Description', "required|max_length[8500]");
    // $this->form_validation->set_rules('image1', 'Image', "required|file_allowed_type[image]");
    //$this->form_validation->set_rules('image1', 'image1', "callback_validateFile[image1,image,false]");
    //echo "true-<pre>";print_r($_POST);die;
    if ($this->form_validation->run() === TRUE) {
     // echo "true-<pre>";print_r($_POST);die;
      $posted_friendly_url = $this->input->post('friendly_url');
      $this->cbk_friendly_url = seo_url_title($posted_friendly_url);  

       $uploaded_file = "";
      if (!empty($_FILES) && $_FILES['image1']['name'] != '') {
        $this->load->library('upload');
        $config1['upload_path'] = UPLOAD_DIR . '/blog/';
        $config1['allowed_types'] = 'gif|jpg|png|jpeg';
        $this->upload->initialize($config1);
        $uploaded_data = $this->upload->do_upload('image1');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
        }
      }

      $posted_data = array(
          'article_title' => $this->input->post('article_title', TRUE),
          'friendly_url' => $this->cbk_friendly_url,
          'blog_author' => $this->input->post('blog_author'),
          'short_desc' => $this->input->post('short_desc'),
          'article_desc' => $this->input->post('article_desc'),
          'article_image' => $uploaded_file,
          'post_date' => $this->config->item('config.date.time')
      );
      $blogId = $this->blog_model->safe_insert('wps_blog', $posted_data, FALSE);
      if ($blogId) {
        $redirect_url = "blog/details";
        $meta_array = array(
            'entity_type' => $redirect_url,
            'entity_id' => $blogId,
            'page_url' => $this->cbk_friendly_url,
            'meta_title' => get_text($this->input->post('article_title'), 80),
            'meta_description' => get_text($this->input->post('article_desc')),
            'meta_keyword' => get_keywords($this->input->post('article_desc'))
        );
        create_meta($meta_array);
      }
      //$this->add_product_media($productId);	
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', lang('success'));
      redirect('wps-admin/blog/index/', '');
    }
   // echo "valid false-<pre>";print_r($_POST);die;
    $this->load->view('blogs/view_blog_add', $data);
  }

  public function edit() {
    $seo_url_length = $this->config->item('seo_url_length');
    $data['heading_title'] = 'Edit Blog';
    $blogId = (int) $this->uri->segment(4);
    $option = array('productid' => $blogId);
    $res = $this->blog_model->get_blog(1, 0, $option);
    $data['res'] = $res;
    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'article_desc'));
    $data['ckeditor1'] = set_ck_config(array('textarea_id' => 'article_desc_p'));

    $this->form_validation->set_rules('article_title', 'Title', "trim|required|max_length[200]");
    $this->form_validation->set_rules('blog_author', 'Author Name', "trim|required|alpha|max_length[80]");
    $this->form_validation->set_rules('short_desc', 'Short Description', "trim|required|max_length[450]");
    $this->form_validation->set_rules('article_desc', 'Description', "required|max_length[8500]");
    $this->form_validation->set_rules('image1', 'Image', "file_allowed_type[image]");

    if (is_array($res) && !empty($res)) {

      $posted_friendly_url = $this->input->post('friendly_url');
      $this->cbk_friendly_url = seo_url_title($posted_friendly_url);
      $redirect_url = "blog/details";

      if ($this->form_validation->run() == TRUE) {

        $uploaded_file = $res['article_image'];
        $unlink_image = array('source_dir' => "blog", 'source_file' => $res['article_image']);

        if (!empty($_FILES) && $_FILES['image1']['name'] != '') {
          $this->load->library('upload');
          $config1['upload_path'] = UPLOAD_DIR . '/blog/';
          $config1['allowed_types'] = 'gif|jpg|png|jpeg';
          $this->upload->initialize($config1);
          $uploaded_data = $this->upload->do_upload('image1');
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file = $uploaded_data['upload_data']['file_name'];
            removeImage($unlink_image);
          }
        }

        $posted_data = array(
            'article_title' => $this->input->post('article_title'),
            'friendly_url' => $this->cbk_friendly_url,
            'blog_author' => $this->input->post('blog_author'),
            'short_desc' => $this->input->post('short_desc'),
            'article_desc' => $this->input->post('article_desc'),
            'article_image' => $uploaded_file
        );
        $where = "article_id = '" . $blogId . "'";
        $this->blog_model->safe_update('wps_blog', $posted_data, $where, FALSE);

        //update meta
        update_meta_page_url($redirect_url, $res['article_id'], $this->cbk_friendly_url);
        //End here

        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', lang('successupdate'));
        redirect('wps-admin/blog/index/', '');
      }
      $this->load->view('blogs/view_blog_edit', $data);
    } else {
      redirect('wps-admin/blog', '');
    }
  }

  public function comment() {
    $ref_article_id = (int) $this->uri->segment(4);
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));

    $keyword = trim($this->input->get_post('keyword', TRUE));
    $keyword = $this->db->escape_str($keyword);

    $condtion = "";

    if ($ref_article_id != '') {
      $condtion = "&& ref_article_id = '" . $ref_article_id . "'";
    }

    $status = $this->input->get_post('status', TRUE);
    $keyword = $this->input->get_post('keyword', TRUE);

    if ($status != '') {
      $condtion['status'] = $status;
    }
    if ($keyword != '') {
      $condtion['keyword'] = $keyword;
    }

    $condtion_array = array(
        'field' => "*",
        'condition' => $condtion,
        'ref_article_id' => $ref_article_id,
        'type' => 'A',
        'debug' => FALSE
    );
    $res_array = $this->blog_model->get_review_comment($config['limit'], $offset, $condtion_array);

    $data['title'] = 'Blog Comment';
    $config['total_rows'] = $this->blog_model->total_rec_found;

   // $data['page_links'] = admin_pagination($base_url, $config['total_rows'], $config['limit'], $offset);

    $data['heading_title'] = 'Comments';

    $data['ref_article_id'] = $ref_article_id;

    $data['res'] = $res_array;

    if ($this->input->post('status_action') != '') {
      $this->update_status('wps_blog_comment', 'comment_id');
    }
    if ($this->input->post('update_order') != '') {
      $this->update_displayOrder('wps_blog_comment', 'sort_order', 'comment_id');
    }

    $this->load->view('blogs/view_comment_list', $data);
  }

}

// End of controller