<div class="videoSection">
    <div class="container">
        <div class="h2_title">Machinery Clinic Insights: Precision in Motion</div>
        <div class="maxWidth">
            <p>Discover a world of cutting-edge machining solutions through engaging product demonstrations. These
                videos provide a closer look at the advanced features and performance of our precision-engineered
                equipment, designed to optimize efficiency and reliability. Gain valuable insights into how our
                innovative products can elevate your operations and meet the evolving demands of the machining industry
                with unmatched excellence.</p>
        </div>
    
     
        <div class="row g-2 mb-5">
            <div class="col-lg-2 col-md-3 col-6">
                <div class="vid-bx" data-video="<?= site_url; ?>/designer/images/videos/video7.mp4">
                    <img src="<?= site_url; ?>/designer/images/videos/VMC-Machine.jpg" title="VMC Machine" alt="VMC Machine"
                        class="video-thumb">
                    <svg class="play-icon" xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="#fff"
                        viewBox="0 0 16 16">
                        <path
                            d="m11.596 8.697-6.363 3.692c-.54.313-1.233-.066-1.233-.697V4.308c0-.63.692-1.01 1.233-.696l6.363 3.692a.802.802 0 0 1 0 1.393" />
                    </svg>
                    <div class="tt">VMC Machine</div>
                </div>
            </div>
            <div class="col-lg-2 col-md-3 col-6">
                <div class="vid-bx" data-video="<?= site_url; ?>/designer/images/videos/video6.mp4">
                    <img src="<?= site_url; ?>/designer/images/videos/Laser-Calibration-of-Rotatory-Axis.jpg" title="Laser Calibration of Rotatory Axis" alt="Laser Calibration of Rotatory Axis"
                        class="video-thumb">
                    <svg class="play-icon" xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="#fff"
                        viewBox="0 0 16 16">
                        <path
                            d="m11.596 8.697-6.363 3.692c-.54.313-1.233-.066-1.233-.697V4.308c0-.63.692-1.01 1.233-.696l6.363 3.692a.802.802 0 0 1 0 1.393" />
                    </svg>
                    <div class="tt">Laser Calibration of Rotatory Axis</div>
                </div>

              
            </div>
            <div class="col-lg-2 col-md-3 col-6">
                <div class="vid-bx" data-video="<?= site_url; ?>/designer/images/videos/video2.mp4">
                    <img src="<?= site_url; ?>/designer/images/videos/Industrial-Robots.jpg" title="Industrial Robots" alt="Industrial Robots"
                        class="video-thumb">
                    <svg class="play-icon" xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="#fff"
                        viewBox="0 0 16 16">
                        <path
                            d="m11.596 8.697-6.363 3.692c-.54.313-1.233-.066-1.233-.697V4.308c0-.63.692-1.01 1.233-.696l6.363 3.692a.802.802 0 0 1 0 1.393" />
                    </svg>
                    <div class="tt">Industrial Robots</div>
                </div>

                
            </div>
            <div class="col-lg-2 col-md-3 col-6">
                <div class="vid-bx" data-video="<?= site_url; ?>/designer/images/videos/video3.mp4">
                    <img src="<?= site_url; ?>/designer/images/videos/Turn-Mill.jpg" title="Turn Mill" alt="Turn Mill"
                        class="video-thumb">
                    <svg class="play-icon" xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="#fff"
                        viewBox="0 0 16 16">
                        <path
                            d="m11.596 8.697-6.363 3.692c-.54.313-1.233-.066-1.233-.697V4.308c0-.63.692-1.01 1.233-.696l6.363 3.692a.802.802 0 0 1 0 1.393" />
                    </svg>
                    <div class="tt">Turn Mill</div>
                </div>

               
            </div>
            <div class="col-lg-2 col-md-3 col-6">
                <div class="vid-bx" data-video="<?= site_url; ?>/designer/images/videos/video4.mp4">
                    <img src="<?= site_url; ?>/designer/images/videos/Laser-Calibration.jpg" title="Laser Calibration" alt="Laser Calibration"
                        class="video-thumb">
                    <svg class="play-icon" xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="#fff"
                        viewBox="0 0 16 16">
                        <path
                            d="m11.596 8.697-6.363 3.692c-.54.313-1.233-.066-1.233-.697V4.308c0-.63.692-1.01 1.233-.696l6.363 3.692a.802.802 0 0 1 0 1.393" />
                    </svg>
                    <div class="tt">Laser Calibration</div>
                </div>

              
            </div>
            <div class="col-lg-2 col-md-3 col-6">
                <div class="vid-bx" data-video="<?= site_url; ?>/designer/images/videos/video5.mp4">
                    <img src="<?= site_url; ?>/designer/images/videos/Mazak-Integrex-30.jpg" title="Mazak Integrex 30" alt="Mazak Integrex 30"
                        class="video-thumb">
                    <svg class="play-icon" xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="#fff"
                        viewBox="0 0 16 16">
                        <path
                            d="m11.596 8.697-6.363 3.692c-.54.313-1.233-.066-1.233-.697V4.308c0-.63.692-1.01 1.233-.696l6.363 3.692a.802.802 0 0 1 0 1.393" />
                    </svg>
                    <div class="tt">Mazak Integrex 30</div>
                </div>

        
            </div>
        </div>
    </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.vid-bx').forEach(function(box) {
        box.addEventListener('click', function() {
            const videoSrc = this.getAttribute('data-video');

            // Remove all children (thumbnail, svg, etc.)
            this.innerHTML = '';

            // Create and insert video
            const video = document.createElement('video');
            video.src = videoSrc;
            video.controls = true;
            video.autoplay = true;
            video.muted = true;
            video.loop = true;
            video.style.width = '100%';
            video.style.height = 'auto';

            this.appendChild(video);
        });
    });
});
</script>