<?php 

include_once("include/main.inc.php"); 

$hover='blog';

$blog_query = mysqli_query($GLOBALS['dbconn'], "SELECT catImage, catName, blogDname, catDesc, blog_written, blogDate FROM blog_tbl ORDER BY catID DESC");

$page_metatitle='Blogs – Event Stage Fabrication Services in Dubai, UAE | Brisk Steel';

$page_metakey='Event Stage Fabrication Services in Dubai, Stage Fabrication in UAE, Event Stage Setup Dubai, Brisk Steel Stage Services, Custom Event Stages UAE, Dubai Event Stage Experts, Stage Construction Services Dubai, Event Stage Solutions UAE';

$page_metadesc='Explore expert insights, trends, and tips on Event Stage Fabrication Services in Dubai, UAE with Brisk Steel. Learn how we design and deliver custom event stages with precision, safety, and style. Stay updated with our latest blogs on stage setup, materials, and fabrication techniques.';

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    
    <?php include "app_top.php"; ?>
</head>

<body>

<div class="header2">
        <?php include "app_header.php"; ?>
    </div>

    <section class="heading_banner" style="background-image: url(<?=site_url;?>/designer/images/aboutsbanner.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Our Blogs - <?=$admin_res['companyName'];?></h1>
                    <div class="clearfix"></div>
                    <!-- <div class="cat_title2">We Are Available For You</div> -->
                </div>
            </div>
        </div>
    </section>

    <div class="inner_breadcrumb hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?=site_url;?>" title="Home">Home</a></li>
                        <li class="active">Our Blogs</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="home_latest_blog">
        <div class="container pb-3">
            <div class="h2_title_1 wow fadeInDown animated" data-wow-delay=".1s">Our Latest Blogs</div>
            <p class="mx-auto text-white text-center mb-4 w-75">Dive into our latest blogs for expert insights, industry trends, and behind-the-scenes looks at our projects. From fabrication tips to event setup ideas, we share valuable knowledge that inspires and informs. Stay updated with fresh content that reflects our innovation, craftsmanship, and dedication to delivering top-quality services across metal works, CNC cutting, event fabrication, and more.</p>
            <div class="row g-4">

            <?php 
                    while($blog_res=mysqli_fetch_array($blog_query)){ 
                    if($blog_res['catImage']!=''){
                    $blog_img=  getImage($blog_res['catImage'], 500, 500, $blog_res['catName'], "/uploaded-files/blog/images/");
                    }else{
                        $blog_img= NO_IMG_URL;
                    }
                    $blog_shortdesc=str_ireplace('{companyName}',$admin_res['companyName'],$blog_res['catDesc']);
                    ?>
                    
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-12 col-12 wow zoomIn animated"
                    data-wow-delay=".2s">
                    <div class="post clearfix">
                        <div class="featured-post">
                            <img src="<?=$blog_img;?>" alt="<?= $blog_res['blogDname'];?>" title="<?= $blog_res['blogDname'];?>">
                            <ul class="post-comment">
                                <!-- <li class="date"><span class="day"> <?php if($blog_res['blogDate']!='') { ?> 
                                    <?=$day;?> 
                                    <?php } ?></span>
                                    
                                </li>
                                <li class="comment"> <?php if($blog_res['blogDate']!='') { ?> 
                                    <?= $month;?> 
                                    <?php } ?>
                                    
                                </li> -->
                            </ul>
                        </div>
                        <div class="content-post">
                            <h2 class="title-post"><a href="<?=site_url;?>/blog/<?=getValidFileName($blog_res['catName']);?>.htm" title="<?= $blog_res['blogDname'];?>"> <?= $blog_res['blogDname'];?></a></h2>

                            <div class="entry-post">
                          <p>  <?= html_entity_decode(substr($blog_shortdesc,0,200)) ;?>...</p>
                                <a class="read_more" href="<?=site_url;?>/blog/<?=getValidFileName($blog_res['catName']);?>.htm" title="Read More"><span>Read More</span> </a>
                            </div>
                        </div>
                    </div>
                </div>

                <?php } ?>


            </div>
        </div>
    </div>




    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>