<?php

include_once("include/main.inc.php"); ?>
<div class="modal fade" id="whatsapp" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <div class="modal-title" id="myModalLabelwhatsapp">Message on WhatsApp</div>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form method="post" id="whatsappEnq">
                    <p id="whatsapp_response"></p>
                    <div class="row">
                        <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="form-group">
                                <input class="form-control" type="text" name="wname" id="wname" onkeypress="return ValidateAlpha(event)" placeholder="Full Name*" value="" required>
                            </div>
                        </div>
                        <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="form-group">
                                <input class="form-control" type="tel" name="wmobile" id="wmobile" value="" onkeyup="this.value=this.value.replace(/[^0-9]/g,'')" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" minlength="10" maxlength="10" placeholder="Mobile Number*" required>
                            </div>
                        </div>
                        <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <button type="submit" name="whatsapp_submit" id="whatsEnq" class="theme-btn btn-style-two"><span>Submit</span></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="myModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <div class="modal-title" id="myModalLabelQuick">Quick Enquiry</div>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="quick_enquiry" method="post" name="quick_enquiry">
                    
                    <div id="enqstatus"></div>
                    <div class="form-group">
                        <input class="form-control" type="text" onkeypress="return ValidateAlpha(event)" name="user_name" id="name" placeholder="Full Name*" value="" required>
                    </div>

                    <div class="form-group">
                        <input class="form-control" type="email" name="email_address" id="email" value="" placeholder="Email ID*" required>
                    </div>

                    <div class="form-group">
                        <input class="form-control" type="tel" name="phone_no" id="phone" onkeyup="this.value=this.value.replace(/[^0-9]/g,'')" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" minlength="10" maxlength="12"  placeholder="Your Mobile Number*" required>
                    </div>

                    <div class="form-group">
                        <input class="form-control" type="text" name="location" id="locations" value="" placeholder="Your Location*" required>
                    </div>

                    <div class="form-group">
                        <textarea class="form-control" name="en_message" id="message" placeholder="Your Message*" required></textarea>
                    </div>

                    <div class="form-group" style="margin-bottom: 0;">
                        <div class="g-recaptcha" data-sitekey="<?=SITE_KEY;?>"></div>
                    </div>

                    <button type="submit" id="sendq" class="theme-btn btn-style-two"><span>Submit</span></button>
                </form>
            </div>
        </div>
    </div>
</div>


<!-- Product Popup -->
<div class="modal fade" id="productID" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <div class="modal-title" id="myModalLabelSend">Send Enquiry</div>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-xxl-7 col-xl-7 col-lg-7 col-md-7 col-sm-7 col-12">
                        <div class="product_popup">
                            <div class="product_popup_image">
                                <img class="product-img catImg" src="designer/images/image1.jpg" alt="Home Tuitions in Delhi" title="Home Tuitions in Delhi">
                            </div>
                            <div class="catName">Hair Transplant</div>
                        </div>
                    </div>
                    <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">

                        <form name="contact-form" method="post" id="quick_enquiry1">
                            <div id="mail-status1"></div>
                            <div class="form-group">
                                <input class="form-control" type="text" name="catuser_name" id="catuser_name" placeholder="Full Name*" value="" onkeypress="return ValidateAlpha(event)" pattern="[a-z A-Z]+" required>
                            </div>

                            <div class="form-group">
                                <input class="form-control" type="email" name="catemail_address" id="catemail_address" placeholder=" Email ID*" value="" required>
                            </div>

                            <div class="form-group">
                                <input class="form-control" name="catphone_no" type="tel" placeholder="Phone No *" minlength="10" maxlength="12" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" value="" id="catphone_no" required>
                            </div>

                            <div class="form-group">
                                <input class="form-control" type="text" name="catlocation" id="catlocation" placeholder="Location*" value="" pattern="[a-z A-Z]+" autocomplete="off" required>
                            </div>
                            <div class="form-group">
                                <textarea class="form-control" name="caten_message" id="caten_message" placeholder=" Message*" required></textarea>
                            </div>

                            <div class="form-group" style="margin-bottom: 0;">
                                <div class="g-recaptcha" data-sitekey="<?=SITE_KEY;?>"></div>
                            </div>

                            <div class="form-group">
                                <button type="submit" id="cat_submit" class="theme-btn btn-style-two"><span>Submit</span></button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $('#whatsEnq').click(function(e) {

            e.preventDefault();
            var wname = $('#wname').val();
            var wmobile = $('#wmobile').val();
            $.ajax({
                url: "<?=site_url;?>/whatsapp_enq.php",
                data: $('#whatsappEnq').serialize(),
                type: "POST",
                success: function(data) {
                    if (data == 'success') {
                        $('#whatsapp_response').html('<div class="alert alert-success">Whatsapp Enquiry Submitted successfully<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>');
                        $('#whatsappEnq').trigger('reset');
                        window.open("https://api.whatsapp.com/send?phone=918767000044&text=&source=&data=&app_absent=","_blank");
                    } else {
                        setTimeout(() => {}, 10000);
                        $('#whatsapp_response').html(data);
                    }
                }

            })

        })
    })

</script>
<script>
    $(document).ready(function() {
        $('#sendq').click(function(e) {
            e.preventDefault();
            if ($("#name").val() != '' && $("#email").val() != '' && $("#phone").val() != '' && $("#message").val() != '' && $("#locations").val() != '') {
                jQuery.ajax({
                    url: "<?=site_url;?>/ajaxEnquiry.php",
                    data: $('#quick_enquiry').serialize(),
                    type: "POST",
                    success: function(data) {
                     
                        if (data.trim() == 'success') {
                            $("#enqstatus").html('<div class="alert alert-success alert-dismissible show">Your Enquiry has been sent successfully.  Our Team will contact you shortly!<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true"></span></button></div>');
                            $('#quick_enquiry')[0].reset();
                     document.getElementById('quick_enquiry').reset();
                       

                        } else {
                            $("#enqstatus").html(data).css('color', 'red');
                        }
                    },
                    error: function() {}
                });
            } else {
                $("#enqstatus").html('<div class="alert alert-danger alert-dismissible show">Asterisk(*) Marked fields are Mandatory!<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true"></span></button></div>');
            }
        })
    });

</script>
<script>
    $(document).ready(function() {
        $('#cat_submit').click(function(e) {
            e.preventDefault();
            if ($("#catuser_name").val() != '' && $("#catemail_address").val() != '' && $("#catphone_no").val() != '' && $("#caten_message").val() != '' && $("#catlocation").val() != '') {
                jQuery.ajax({
                    url: "<?=site_url;?>/ajaxEnquirycat.php",
                    data: $('#quick_enquiry1').serialize(),
                    type: "POST",
                    success: function(data) {
                        var data = data.trim();
                        if (data == 'success') {
                            $("#mail-status1").html('<div class="alert alert-success alert-dismissible show">Your Enquiry has been sent successfully.  Our Team will contact you shortly!<button type="button" class="close" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>');
                            $('#quick_enquiry1').trigger('reset');
                           

                        } else {
                            $("#mail-status1").html(data).css('color', 'red');
                        }
                    },
                    error: function() {}
                });
            } else {
                $("#mail-status1").html('<div class="alert alert-danger alert-dismissible show"><strong>Asterisk(*) Marked fields are Mandatory!<button type="button" class="close" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>');
            }

        })

    })

</script>
