<?php
include_once("include/main.inc.php");
$hover = 'gallery';
$page_metatitle = "Certificates of Aadish Mechatronics | Our Commitment to Quality and Excellence";
$page_metakey = "Certifications, Quality Assurance, Industry Standards, Compliance";
$page_metadesc = "Look at our Certificates that highlight our dedication to quality, compliance, and industry standards, ensuring excellence in every product and service we deliver.";
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <?php include "app_top.php"; ?>
</head>

<body>
    <?php include "app_header.php"; ?>
    <section class="heading_banner" style="background-image: url(<?= site_url; ?>/designer/images/about/about-us.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Dealership - <?= $admin_res['companyName']; ?></h1>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </section>

    <div class="inner_breadcrumb hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?= site_url; ?>" title="Home">Home</a></li>
                        <li class="active">Dealership</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <section class="testimonial_page">
        <div class="container">
            <div class="tt-bx mb-4">
                <h2 class="tt">Our <span>Dealership Credentials</span></h2>
                <p>Step into a world of trusted quality with our certified products, designed to exceed industry standards. Each product, including Weighing Scales, Moisture Analyzers, and Spectrophotometers, undergoes rigorous testing and holds global certifications. These certifications guarantee superior performance, accuracy, and reliability, ensuring your laboratory processes are supported by the highest-quality equipment available.</p>
            </div>
            <div class="row g-4 row-cols-1 row-cols-md-2 row-cols-lg-3 justify-content-center">
                <?php $certificate_sql = mysqli_query($GLOBALS['dbconn'], "select * from certificates_tbl order by id ASC");
                if (mysqli_num_rows($certificate_sql) > 0) {
                    while ($certificate_res = mysqli_fetch_assoc($certificate_sql)) {

                        $certificateImg = getImage($certificate_res[gallery_image], 480, 480, $certificate_res[gallery_title] . $certificate_res[id], "/uploaded-files/certificates/");
                        $certificateImg1 = getImage($certificate_res[gallery_image], 1000, 800, $certificate_res[gallery_title] . $certificate_res[id], "/uploaded-files/certificates/");

                ?>
                        <div class="col">
                            <div class="certificate-bx">
                                <a class="img" href="<?= site_url; ?>/uploaded-files/certificates/<?= $certificate_res['catalog']; ?>" title="<?= $certificate_res['image_name']; ?>" target="_blank">
                                    <img src="<?= site_url; ?>/uploaded-files/certificates/<?= $certificate_res['gallery_image']; ?>" alt="<?= $certificate_res['image_name']; ?>" title="<?= $certificate_res['image_name']; ?>">
                                </a>
                                <div class="tt"><?= $certificate_res['image_name']; ?></div>
                            </div>
                        </div>
                <?php }
                } ?>

            </div>
        </div>
    </section>
    <div class="client-sec" style="background: #f7f7f7;">
        <div class="container">
            <div class="tt-bx mb-4">
                <div class="tt fs-2">Our Trusted <span>Dealership Partners</span></div>
            </div>
            <div class="row g-3 row-cols-2 row-cols-md-4 row-cols-lg-6 justify-content-center">
                <div class="col">
                    <div class="client-img">
                        <img src="designer/images/dealership-logo/ASV-Analytical-Logo.jpg" alt="ASV Analytical" title="ASV Analytical">
                    </div>
                </div>
                <div class="col">
                    <div class="client-img">
                        <img src="designer/images/dealership-logo/Atago-Logo.jpg" alt="Atago" title="Atago">
                    </div>
                </div>
                <div class="col">
                    <div class="client-img">
                        <img src="designer/images/dealership-logo/Borosil-Scientific-Logo.jpg" alt="Borosil Scientific" title="Borosil Scientific">
                    </div>
                </div>
                <div class="col">
                    <div class="client-img">
                        <img src="designer/images/dealership-logo/Deeksha-Analytical-Logo.jpg" alt="Deeksha Analytical" title="Deeksha Analytical">
                    </div>
                </div>
                <div class="col">
                    <div class="client-img">
                        <img src="designer/images/dealership-logo/Hally-Instruments-Logo.jpg" alt="Hally Instruments" title="Hally Instruments">
                    </div>
                </div>
                <div class="col">
                    <div class="client-img">
                        <img src="designer/images/dealership-logo/Hanna-Instruments-Logo.jpg" alt="Hanna Instruments" title="Hanna Instruments">
                    </div>
                </div>
                <div class="col">
                    <div class="client-img">
                        <img src="designer/images/dealership-logo/J-Sil-Logo.jpg" alt="J Sil" title="J Sil">
                    </div>
                </div>
                <div class="col">
                    <div class="client-img">
                        <img src="designer/images/dealership-logo/Labindia-Analytical-Logo.jpg" alt="Labindia Analytical" title="Labindia Analytical">
                    </div>
                </div>
                <div class="col">
                    <div class="client-img">
                        <img src="designer/images/dealership-logo/Mettler-Toledo-Logo.jpg" alt="Mettler Toledo" title="Mettler Toledo">
                    </div>
                </div>
                <div class="col">
                    <div class="client-img">
                        <img src="designer/images/dealership-logo/Rentokil-Initial-Logo.jpg" alt="Rentokil Initial" title="Rentokil Initial">
                    </div>
                </div>
                <div class="col">
                    <div class="client-img">
                        <img src="designer/images/dealership-logo/Samrat-Polymers-Logo.jpg" alt="Samrat Polymers" title="Samrat Polymers">
                    </div>
                </div>
                <div class="col">
                    <div class="client-img">
                        <img src="designer/images/dealership-logo/Sartorius-Logo.jpg" alt="Sartorius" title="Sartorius">
                    </div>
                </div>
                <div class="col">
                    <div class="client-img">
                        <img src="designer/images/dealership-logo/Veego-Logo.jpg" alt="Veego" title="Veego">
                    </div>
                </div>
                <div class="col">
                    <div class="client-img">
                        <img src="designer/images/dealership-logo/Weigh-Denvar-Logo.jpg" alt="Weigh Denvar" title="Weigh Denvar">
                    </div>
                </div>
                <div class="col">
                    <div class="client-img">
                        <img src="designer/images/dealership-logo/Xing-Yun-Logo.jpg" alt="Xing Yun" title="Xing Yun">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>